/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetClass;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetType;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetCreationSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.io.json.game.generator.JSONToTextureCreationSettings;
import com.neutronio.astrax.util.JSONUtils;
import java.util.List;
import java.util.Map;

public class JSONToPlanetCreationSettings
extends GameDataJSONConverter<PlanetCreationSettings, Map> {
    protected JSONToTextureCreationSettings textureSettingsConverter = this.getLoader().getConverter(JSONToTextureCreationSettings.class);

    public JSONToPlanetCreationSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public PlanetCreationSettings convert(Map input) {
        if (input == null) {
            return null;
        }
        PlanetCreationSettings settings = new PlanetCreationSettings();
        String id = (String)input.get("id");
        if (!input.containsKey("name")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, String.format("name in '%s'", id));
        }
        settings.name = (String)input.get("name");
        if (input.containsKey("icon")) {
            settings.icon = (String)input.get("icon");
        }
        if (input.containsKey("entityID")) {
            settings.entityId = (String)input.get("entityID");
        }
        if (input.containsKey("description")) {
            settings.description = (String)input.get("description");
        }
        if (!input.containsKey("scale")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, String.format("scale in '%s'", id));
        }
        settings.setScale(Float.valueOf(((Number)input.get("scale")).floatValue()));
        if (!input.containsKey("axisTilt")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, String.format("axisTilt in '%s'", id));
        }
        settings.setAxisTilt(Float.valueOf(((Number)input.get("axisTilt")).floatValue()));
        if (!input.containsKey("planetClass")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, String.format("planetClass in '%s'", id));
        }
        settings.planetClass = JSONUtils.toEnum(PlanetClass.class, input.get("planetClass"));
        if (!input.containsKey("planetType")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, String.format("planetType in '%s'", id));
        }
        settings.planetType = JSONUtils.toEnum(PlanetType.class, input.get("planetType"));
        if (!input.containsKey("traits")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, String.format("traits in '%s'", id));
        }
        List traitList = (List)input.get("traits");
        settings.setTraits(traitList);
        if (!input.containsKey("rarity")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, String.format("rarity in '%s'", id));
        }
        settings.rarity = JSONUtils.toEnum(Discovery.Rarity.class, input.get("rarity"));
        if (!input.containsKey("discoveryPoints")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, String.format("discoveryPoints in '%s'", id));
        }
        settings.discoveryPoints = JSONUtils.toInteger(input.get("discoveryPoints"));
        if (input.containsKey("textureSettings")) {
            List settingMaps = (List)input.get("textureSettings");
            for (Map settingMap : settingMaps) {
                settings.textureSettings.add(this.textureSettingsConverter.convert(settingMap));
            }
        } else {
            throw new AstraXException(AstraXException.ErrorCode.E2005, String.format("textureSettings in '%s'", id));
        }
        if (input.containsKey("useShadowMask")) {
            settings.useShadowMask = (Boolean)input.get("useShadowMask");
        }
        if (input.containsKey("tags")) {
            settings.tags = JSONUtils.toStringList(input.get("tags"));
        }
        return settings;
    }
}

