/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetClass;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetGenerationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetType;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.io.json.game.JSONToTechTree;
import com.neutronio.astrax.io.json.game.generator.JSONToPlanetTextureSettings;
import com.neutronio.astrax.util.JSONUtils;
import java.util.Map;

public class JSONToPlanetGenerationSettings
extends GameDataJSONConverter<PlanetGenerationSettings, Map> {
    JSONToPlanetTextureSettings textureSettingConverter;
    JSONToTechTree techTreeConverter;

    public JSONToPlanetGenerationSettings(DataManager loader) {
        super(loader);
        this.textureSettingConverter = loader.getConverter(JSONToPlanetTextureSettings.class);
        this.techTreeConverter = loader.getConverter(JSONToTechTree.class);
    }

    @Override
    public PlanetGenerationSettings convert(Map input) {
        PlanetGenerationSettings settings = new PlanetGenerationSettings();
        this.convert(settings, input);
        return settings;
    }

    @Override
    public void convert(PlanetGenerationSettings destination, Map input) {
        destination.name = (String)input.get("name");
        destination.icon = (String)input.get("icon");
        destination.planetClass = JSONUtils.toEnum(PlanetClass.class, input.get("planetClass"));
        destination.planetType = JSONUtils.toEnum(PlanetType.class, input.get("planetType"));
        destination.maxAxisTilt = JSONUtils.toFloat(input.get("maxAxisTilt"));
        destination.maxAxisTilt = JSONUtils.toFloat(input.get("maxAxisTilt"));
        destination.minScale = JSONUtils.toFloat(input.get("minScale"));
        destination.maxScale = JSONUtils.toFloat(input.get("maxScale"));
        destination.rarity = JSONUtils.toEnum(Discovery.Rarity.class, input.get("rarity"));
        destination.discoveryPoints = JSONUtils.toInteger(input.get("discoveryPoints"));
        if (input.containsKey("useShadowMask")) {
            destination.useShadowMask = (Boolean)input.get("useShadowMask");
        }
        destination.traits = this.techTreeConverter.convert((Map)input.get("traits"));
        destination.tags = JSONUtils.toStringList(input.get("tags"));
    }
}

