/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.TextureGenerationSetting;
import com.neutronio.astrax.app.repository.ColorRepository;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.util.JSONUtils;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class JSONToPlanetTextureSettings
extends GameDataJSONConverter<TextureGenerationSetting, Map> {
    protected ColorRepository colorRepository;
    protected Map<String, Color> planetPalette;

    protected JSONToPlanetTextureSettings(DataManager loader) {
        super(loader);
    }

    private void lazyLoad() {
        if (this.colorRepository != null) {
            return;
        }
        this.colorRepository = AstraXApp.astraX.getRepository(ColorRepository.class);
        this.planetPalette = (Map)this.colorRepository.find("palette-planet");
    }

    @Override
    public TextureGenerationSetting convert(Map textureProperties) {
        if (textureProperties == null) {
            return null;
        }
        this.lazyLoad();
        TextureGenerationSetting textureGenerationSetting = new TextureGenerationSetting();
        String texture = (String)textureProperties.get("texture");
        List colorList = (List)textureProperties.get("colors");
        String minRotation = (String)textureProperties.get("minRotation");
        String maxRotation = (String)textureProperties.get("maxRotation");
        Float rotationSpeed = Float.valueOf(0.0f);
        if (textureProperties.containsKey("rotationSpeed")) {
            rotationSpeed = Float.valueOf(((Number)textureProperties.get("rotationSpeed")).floatValue());
            rotationSpeed = Float.valueOf(MathUtils.clamp(rotationSpeed.floatValue(), 0.0f, 1.0f));
        }
        if (textureProperties.containsKey("layer")) {
            textureGenerationSetting.layer = JSONUtils.toInteger(textureProperties.get("layer"));
        }
        if (textureProperties.containsKey("alphaOverride")) {
            textureGenerationSetting.alphaOverride = JSONUtils.toFloat(textureProperties.get("alphaOverride"));
        }
        Color[] colors = new Color[colorList.size()];
        int i2 = 0;
        for (Object colorName : colorList) {
            Color color = this.planetPalette.get((String)colorName);
            if (color == null) {
                this.logger.log(Level.WARNING, "Could not find Color '" + colorName + "' in ColorSet");
            }
            colors[i2] = color;
            ++i2;
        }
        textureGenerationSetting.setTexture(texture);
        textureGenerationSetting.setRotationsSpeed(rotationSpeed.floatValue());
        textureGenerationSetting.setMinRotation(this.getFloat(minRotation));
        textureGenerationSetting.setMaxRotation(this.getFloat(maxRotation));
        textureGenerationSetting.setColor(colors);
        return textureGenerationSetting;
    }

    private float getFloat(String number) {
        if (number == null) {
            return 0.0f;
        }
        if (number.isEmpty()) {
            return 0.0f;
        }
        return Float.valueOf(number).floatValue();
    }
}

