/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.discovery.TraitType;
import com.neutronio.astrax.app.datapack.game.world.OrbitRingSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.Climate;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.TextureGenerationSetting;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.Topography;
import com.neutronio.astrax.app.repository.ColorRepository;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.io.json.game.generator.JSONToClimate;
import com.neutronio.astrax.io.json.game.generator.JSONToPlanetTextureSettings;
import com.neutronio.astrax.io.json.game.generator.JSONToResourceSettings;
import com.neutronio.astrax.io.json.game.generator.JSONToTopography;
import com.neutronio.astrax.util.JSONUtils;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class JSONToPlanetTraits
extends GameDataJSONConverter<PlanetTrait, Map<String, Object>> {
    protected ColorRepository colorRepository;
    protected Map<String, Color> planetPalette;

    protected JSONToPlanetTraits(DataManager dataManager) {
        super(dataManager);
    }

    private void lazyLoad() {
        if (this.colorRepository != null) {
            return;
        }
        this.colorRepository = AstraXApp.astraX.getRepository(ColorRepository.class);
        this.planetPalette = (Map)this.colorRepository.find("palette-planet");
    }

    @Override
    public PlanetTrait convert(Map<String, Object> input) {
        GameDataJSONConverter loadedConverter;
        this.lazyLoad();
        JSONToPlanetTextureSettings textureSettingsConverter = this.loader.getConverter(JSONToPlanetTextureSettings.class);
        PlanetTrait trait = new PlanetTrait();
        trait.id = (String)input.get("id");
        trait.name = (String)input.get("name");
        trait.icon = (String)input.get("icon");
        trait.description = (String)input.get("discoveryDescription");
        trait.discoveryPoints = ((Number)input.get("discoveryPoints")).intValue();
        trait.targetIcon = (String)input.get("targetIcon");
        if (input.containsKey("textureSettings")) {
            for (Object textureSettingMap : (List)input.get("textureSettings")) {
                TextureGenerationSetting textureSetting = textureSettingsConverter.convert((Map)textureSettingMap);
                trait.addTextureSetting(textureSetting);
            }
        }
        if (input.containsKey("orbitRingSettings")) {
            for (Object orbitSettingMap : (List)input.get("orbitRingSettings")) {
                Map orbitSetting = (Map)orbitSettingMap;
                OrbitRingSettings orbitRingSettings = new OrbitRingSettings();
                orbitRingSettings.distanceFactor = JSONUtils.toFloat(orbitSetting.get("distanceFactor"));
                orbitRingSettings.thickness = JSONUtils.toInteger(orbitSetting.get("thickness"));
                List colorList = (List)orbitSetting.get("colors");
                orbitRingSettings.colors = new Color[colorList.size()];
                int i2 = 0;
                for (Object colorName : colorList) {
                    Color color = this.planetPalette.get((String)colorName);
                    if (color == null) {
                        this.logger.log(Level.WARNING, "Could not find Color '" + colorName + "' in ColorSet");
                    }
                    orbitRingSettings.colors[i2] = color;
                    ++i2;
                }
                trait.addOrbitRing(orbitRingSettings);
            }
        }
        String category = (String)input.get("category");
        trait.category = TraitType.valueOf(category);
        if (input.containsKey("resourceSettings")) {
            JSONToResourceSettings jsonToResourceSettings = this.getLoader().getConverter(JSONToResourceSettings.class);
            trait.resourceDepositSettings = jsonToResourceSettings.convert((Map)input.get("resourceSettings"));
        }
        if (input.containsKey("topography")) {
            loadedConverter = this.loader.getConverter(JSONToTopography.class);
            Topography topography = ((JSONToTopography)loadedConverter).convert((Map)input.get("topography"));
            trait.setTopography(topography);
        }
        if (input.containsKey("climate")) {
            loadedConverter = this.loader.getConverter(JSONToClimate.class);
            Climate climate = ((JSONToClimate)loadedConverter).convert((Map)input.get("climate"));
            trait.setClimate(climate);
        }
        return trait;
    }
}

