/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.neutronio.astrax.app.datapack.game.mechanics.resources.ResourceDepositSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.io.json.game.JSONToProbabilitySet;
import com.neutronio.astrax.sfx.ShuffleSound;
import com.neutronio.astrax.util.collections.ProbabilitySet;
import java.util.Map;

public class JSONToResourceSettings
extends GameDataJSONConverter<ResourceDepositSettings, Map<String, Object>> {
    protected JSONToResourceSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public ResourceDepositSettings convert(Map<String, Object> input) {
        JSONToProbabilitySet jsonToProbabilitySet = this.loader.getConverter(JSONToProbabilitySet.class);
        ResourceDepositSettings resourceDepositSettings = new ResourceDepositSettings();
        resourceDepositSettings.setDepositName((String)input.get("depositName"));
        resourceDepositSettings.setMaxMiningDifficulty(((Number)input.get("maxMiningDifficulty")).floatValue());
        resourceDepositSettings.setMinMiningDifficulty(((Number)input.get("minMiningDifficulty")).floatValue());
        resourceDepositSettings.setMaxDepositSize(((Number)input.get("maxDepositSize")).intValue());
        resourceDepositSettings.setMinDepositSize(((Number)input.get("minDepositSize")).intValue());
        if (input.containsKey("sound")) {
            Map soundMap = (Map)input.get("sound");
            ShuffleSound sound = new ShuffleSound();
            sound.setSoundID((String)soundMap.get("soundID"));
            sound.setSoundCount(((Number)soundMap.get("soundCount")).intValue());
            resourceDepositSettings.setSound(sound);
        }
        ProbabilitySet<String> set = jsonToProbabilitySet.convert((Map)input.get("resources"));
        resourceDepositSettings.setResources(set);
        return resourceDepositSettings;
    }
}

