/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteSettings;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.io.json.game.JSONToProbabilitySet;
import com.neutronio.astrax.util.JSONUtils;
import java.util.Map;

public class JSONToSatelliteSettings
extends GameDataJSONConverter<SatelliteSettings, Map> {
    private JSONToProbabilitySet jsonToProbabilitySet = this.getLoader().getConverter(JSONToProbabilitySet.class);

    protected JSONToSatelliteSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public SatelliteSettings convert(Map input) {
        if (input == null) {
            return null;
        }
        SatelliteSettings settings = new SatelliteSettings();
        if (!input.containsKey("id")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "id");
        }
        settings.id = (String)input.get("id");
        if (input.containsKey("name")) {
            settings.name = (String)input.get("name");
        } else if (input.containsKey("namePattern")) {
            settings.namePattern = JSONUtils.toStringList(input.get("namePattern"));
        }
        if (!input.containsKey("possibleMerchants")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "possibleMerchants");
        }
        settings.possibleMerchants = this.jsonToProbabilitySet.convert((Map)input.get("possibleMerchants"));
        if (!input.containsKey("fileLocation") || !input.containsKey("filePath")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "fileLocation / filePath");
        }
        FileHandler.FileLocation fileLocation = JSONUtils.toEnum(FileHandler.FileLocation.class, input.get("fileLocation"));
        String filePath = (String)input.get("filePath");
        settings.fileLocation = new AstraXFiles.AstraXFile(null, filePath, fileLocation);
        if (input.containsKey("tags")) {
            settings.tags = JSONUtils.toStringList(input.get("tags"));
        }
        return settings;
    }
}

