/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.repository.ColorRepository;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.util.ColorBlend;
import com.neutronio.astrax.util.JSONUtils;
import java.util.List;
import java.util.Map;

public class JSONToStarSystemBackgroundSettings
extends GameDataJSONConverter<StarSystemBackgroundSettings, Map> {
    protected ColorRepository colorRepository;
    protected Map<String, Color> planetPalette;

    protected JSONToStarSystemBackgroundSettings(DataManager loader) {
        super(loader);
    }

    private void lazyLoad() {
        if (this.colorRepository != null) {
            return;
        }
        this.colorRepository = AstraXApp.astraX.getRepository(ColorRepository.class);
        this.planetPalette = (Map)this.colorRepository.find("palette-planet");
    }

    @Override
    public StarSystemBackgroundSettings convert(Map input) {
        this.lazyLoad();
        StarSystemBackgroundSettings backgroundSettings = new StarSystemBackgroundSettings();
        if (input.containsKey("colors")) {
            List baseColorList = (List)input.get("colors");
            backgroundSettings.colors = new Color[baseColorList.size()];
            for (int i2 = 0; i2 < backgroundSettings.colors.length; ++i2) {
                backgroundSettings.colors[i2] = this.planetPalette.get((String)baseColorList.get(i2));
            }
        }
        if (input.containsKey("colorBlend")) {
            backgroundSettings.colorBlend = JSONUtils.toEnum(ColorBlend.class, input.get("colorBlend"));
        }
        List scatterSettings = (List)input.get("scatterSettings");
        for (Map scatterSettingsMap : scatterSettings) {
            StarSystemBackgroundSettings.BackgroundScatterSetting scatterSetting = new StarSystemBackgroundSettings.BackgroundScatterSetting();
            scatterSetting.textureRegions = (String)scatterSettingsMap.get("textureRegions");
            List colorList = (List)scatterSettingsMap.get("colors");
            scatterSetting.colors = new Color[colorList.size()];
            for (int i3 = 0; i3 < scatterSetting.colors.length; ++i3) {
                scatterSetting.colors[i3] = this.planetPalette.get((String)colorList.get(i3));
            }
            scatterSetting.minRotation = ((Number)scatterSettingsMap.get("minRotation")).floatValue();
            scatterSetting.maxRotation = ((Number)scatterSettingsMap.get("maxRotation")).floatValue();
            scatterSetting.minTransparency = ((Number)scatterSettingsMap.get("minTransparency")).floatValue();
            scatterSetting.minTransparency = ((Number)scatterSettingsMap.get("maxTransparency")).floatValue();
            scatterSetting.minScale = ((Number)scatterSettingsMap.get("minScale")).floatValue();
            scatterSetting.maxScale = ((Number)scatterSettingsMap.get("maxScale")).floatValue();
            if (scatterSettingsMap.containsKey("baseDensity")) {
                scatterSetting.baseDensity = ((Number)scatterSettingsMap.get("baseDensity")).floatValue();
            }
            backgroundSettings.scatterSettings.add(scatterSetting);
        }
        return backgroundSettings;
    }
}

