/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.io.json.game.JSONToProbabilitySet;
import com.neutronio.astrax.io.json.game.generator.JSONToOrbitSettings;
import com.neutronio.astrax.io.json.game.generator.JSONToOrbitalBeltSettings;
import com.neutronio.astrax.util.JSONUtils;
import com.neutronio.astrax.util.TargetSettings;
import com.neutronio.astrax.util.collections.ProbabilitySet;
import java.util.Map;

public class JSONToTargetSettings
extends GameDataJSONConverter<TargetSettings, Map> {
    protected JSONToTargetSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public TargetSettings convert(Map input) {
        boolean validPayload;
        if (input == null) {
            return null;
        }
        JSONToOrbitSettings orbitConverter = this.getLoader().getConverter(JSONToOrbitSettings.class);
        TargetSettings settings = new TargetSettings();
        if (input.containsKey("probability")) {
            settings.probability = ((Number)input.get("probability")).floatValue();
        }
        if (input.containsKey("id")) {
            settings.id = (String)input.get("id");
        }
        if (input.containsKey("exclude")) {
            settings.exclude = JSONUtils.toStringList(input.get("exclude"));
        }
        if (input.containsKey("tags")) {
            settings.tags = JSONUtils.toStringList(input.get("tags"));
        }
        if (input.containsKey("set")) {
            JSONToProbabilitySet probabilitySetConverter = this.getLoader().getConverter(JSONToProbabilitySet.class);
            ProbabilitySet<String> probabilitySet = probabilitySetConverter.convert((Map)input.get("set"));
            settings.set = probabilitySet;
        }
        if (!input.containsKey("orbitSettings") && !input.containsKey("orbitalBeltSettings")) {
            throw new AstraXException(AstraXException.ErrorCode.E3102, "If no field 'orbitalBeltSettings' is present, 'orbitSettings' must be set!");
        }
        if (input.containsKey("orbitSettings")) {
            OrbitSettings orbitSettings;
            settings.orbitSettings = orbitSettings = orbitConverter.convert((Map)input.get("orbitSettings"));
        }
        if (input.containsKey("maxSpecimens")) {
            settings.maxSpecimens = ((Number)input.get("maxSpecimens")).intValue();
        }
        boolean bl = validPayload = input.containsKey("id") || input.containsKey("tags") || input.containsKey("set") || input.containsKey("orbitalBeltSettings");
        if (!validPayload) {
            throw new AstraXException(AstraXException.ErrorCode.E3102, "Payload must be set! Must be either a valid id (field 'id'), probability set (field 'set'), tags (String field: 'tags') or orbitalBeltSettings");
        }
        if (input.containsKey("orbitalBeltSettings")) {
            JSONToOrbitalBeltSettings jsonToOrbitalBeltSettings = this.getLoader().getConverter(JSONToOrbitalBeltSettings.class);
            settings.orbitalBeltSettings = jsonToOrbitalBeltSettings.convert((Map)input.get("orbitalBeltSettings"));
        }
        return settings;
    }
}

