/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.TextureCreationSettings;
import com.neutronio.astrax.app.repository.ColorRepository;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.util.JSONUtils;
import java.util.Map;

public class JSONToTextureCreationSettings
extends GameDataJSONConverter<TextureCreationSettings, Map> {
    private ColorRepository colorRepository;
    protected Map<String, Color> planetPalette;

    protected JSONToTextureCreationSettings(DataManager loader) {
        super(loader);
    }

    private void lazyLoad() {
        if (this.colorRepository != null) {
            return;
        }
        this.colorRepository = AstraXApp.astraX.getRepository(ColorRepository.class);
        this.planetPalette = (Map)this.colorRepository.find("palette-planet");
    }

    @Override
    public TextureCreationSettings convert(Map input) {
        this.lazyLoad();
        TextureCreationSettings settings = new TextureCreationSettings();
        settings.layer = input.containsKey("layer") ? JSONUtils.toInteger(input.get("layer")) : 0;
        settings.texture = (String)input.get("texture");
        Object colorValue = input.get("color");
        if (colorValue instanceof Map) {
            settings.color = JSONUtils.toColor(colorValue);
        } else if (colorValue instanceof String) {
            settings.color = this.planetPalette.get((String)colorValue);
        }
        settings.alphaOverride = input.containsKey("alphaOverride") ? JSONUtils.toFloat(input.get("alphaOverride")) : 1.0f;
        settings.rotation = input.containsKey("rotation") ? JSONUtils.toFloat(input.get("rotation")) : 0.0f;
        if (input.containsKey("rotationsSpeed")) {
            settings.rotationsSpeed = JSONUtils.toFloat(input.get("rotationsSpeed"));
        }
        return settings;
    }
}

