/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.repository;

import com.neutronio.astrax.app.repository.AnimatedParticleEmitterRepository;
import com.neutronio.astrax.gfx.AnimatedParticleEmitterSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.JSONToAnimatedParticleEmitterSettings;
import com.neutronio.astrax.io.json.game.RepositoryJSONConverter;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONObject;

public class JSONToAnimatedParticleEmitterRepository
extends RepositoryJSONConverter<AnimatedParticleEmitterRepository, String> {
    protected JSONToAnimatedParticleEmitterRepository(DataManager loader) {
        super(loader);
    }

    @Override
    public AnimatedParticleEmitterRepository convert(String input) {
        AnimatedParticleEmitterRepository repository = new AnimatedParticleEmitterRepository();
        this.convertAndStore(repository, input);
        return repository;
    }

    @Override
    public void convertAndStore(AnimatedParticleEmitterRepository repositoryStore, String input) {
        JSONToAnimatedParticleEmitterSettings jsonToAnimatedParticleEmitterSettings = ((DataManager)((Object)this.getLoader())).getConverter(JSONToAnimatedParticleEmitterSettings.class);
        Map<String, Object> emitterMap = new JSONObject(input).toMap();
        int loaded = 0;
        for (String key : emitterMap.keySet()) {
            AnimatedParticleEmitterSettings emitterSettings = jsonToAnimatedParticleEmitterSettings.convert((Map)emitterMap.get(key));
            emitterSettings.id = key;
            repositoryStore.add(key, emitterSettings);
            ++loaded;
        }
        this.logger.log(Level.INFO, "Loaded {0} Particle Emitters", loaded);
    }

    @Override
    public JSONObject convertToJSON(AnimatedParticleEmitterRepository object) {
        JSONObject repositoryJSON = new JSONObject();
        JSONToAnimatedParticleEmitterSettings converter = ((DataManager)((Object)this.getLoader())).getConverter(JSONToAnimatedParticleEmitterSettings.class);
        List allObjects = object.all();
        for (AnimatedParticleEmitterSettings setting : allObjects) {
            repositoryJSON.put(setting.id, converter.convertToJSON(setting));
        }
        return repositoryJSON;
    }
}

