/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.repository;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidGeneratorSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidGeneratorSettingsRepository;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.RepositoryJSONConverter;
import com.neutronio.astrax.io.json.game.generator.JSONToResourceSettings;
import com.neutronio.astrax.util.JSONUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONObject;

public class JSONToAsteroidGeneratorSettingsRepository
extends RepositoryJSONConverter<AsteroidGeneratorSettingsRepository, String> {
    protected JSONToAsteroidGeneratorSettingsRepository(DataManager loader) {
        super(loader);
    }

    @Override
    public AsteroidGeneratorSettingsRepository convert(String input) {
        AsteroidGeneratorSettingsRepository repository = new AsteroidGeneratorSettingsRepository();
        this.convertAndStore(repository, input);
        return repository;
    }

    @Override
    public void convertAndStore(AsteroidGeneratorSettingsRepository repositoryStore, String input) {
        Map<String, Object> asteroidMap = new JSONObject(input).toMap();
        JSONToResourceSettings jsonToResourceSettings = ((DataManager)((Object)this.getLoader())).getConverter(JSONToResourceSettings.class);
        int loaded = 0;
        for (String key : asteroidMap.keySet()) {
            Map attributeMap = (Map)asteroidMap.get(key);
            if (!attributeMap.containsKey("id")) {
                throw new AstraXException(AstraXException.ErrorCode.E2005, "id");
            }
            if (!attributeMap.containsKey("resourceSettings")) {
                throw new AstraXException(AstraXException.ErrorCode.E2005, "resourceSettings");
            }
            if (!attributeMap.containsKey("bodyColors")) {
                throw new AstraXException(AstraXException.ErrorCode.E2005, "bodyColors");
            }
            if (!attributeMap.containsKey("bodyImages")) {
                throw new AstraXException(AstraXException.ErrorCode.E2005, "bodyImages");
            }
            AsteroidGeneratorSettings asteroidGeneratorSettings = new AsteroidGeneratorSettings();
            asteroidGeneratorSettings.id = (String)attributeMap.get("id");
            asteroidGeneratorSettings.resourceDepositSettings = jsonToResourceSettings.convert((Map)attributeMap.get("resourceSettings"));
            List colorMaps = (List)attributeMap.get("bodyColors");
            ArrayList<Color> color = new ArrayList<Color>();
            for (Map colorMap : colorMaps) {
                color.add(JSONUtils.toColor(colorMap));
            }
            asteroidGeneratorSettings.bodyColors = color;
            asteroidGeneratorSettings.bodyImages = (List)attributeMap.get("bodyImages");
            asteroidGeneratorSettings.tags = JSONUtils.toStringList(attributeMap.get("tags"));
            if (attributeMap.containsKey("resourceImages")) {
                asteroidGeneratorSettings.resourceImages = (List)attributeMap.get("resourceImages");
            }
            if (attributeMap.containsKey("particleEmitters")) {
                asteroidGeneratorSettings.particleEmitters = (List)attributeMap.get("particleEmitters");
            }
            repositoryStore.add(asteroidGeneratorSettings.id, asteroidGeneratorSettings);
            ++loaded;
        }
        this.logger.log(Level.INFO, "Loaded {0} AsteroidGeneratorSettings", loaded);
    }
}

