/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.repository;

import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.Classification;
import com.neutronio.astrax.app.repository.ClassificationRepository;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.JSONToClassification;
import com.neutronio.astrax.io.json.game.RepositoryJSONConverter;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONObject;

public class JSONToClassificationRepository
extends RepositoryJSONConverter<ClassificationRepository, String> {
    protected JSONToClassificationRepository(DataManager loader) {
        super(loader);
    }

    @Override
    public void convertAndStore(ClassificationRepository repositoryStore, String input) {
        JSONToClassification jsonToClassification = ((DataManager)((Object)this.getLoader())).getConverter(JSONToClassification.class);
        int loaded = 0;
        Map<String, Object> classificationMap = new JSONObject(input).toMap();
        for (String classKey : classificationMap.keySet()) {
            Classification classification = jsonToClassification.convert((Map)classificationMap.get(classKey));
            repositoryStore.add(classification.getId(), classification);
            ++loaded;
        }
        this.logger.log(Level.INFO, "Loaded {0} Planet Classifications", loaded);
    }

    @Override
    public ClassificationRepository convert(String input) {
        ClassificationRepository classificationRepository = new ClassificationRepository();
        this.convertAndStore(classificationRepository, input);
        return classificationRepository;
    }
}

