/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.repository;

import com.neutronio.astrax.app.repository.ColorRepository;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.RepositoryJSONConverter;
import com.neutronio.astrax.util.JSONUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class JSONToColorRepository
extends RepositoryJSONConverter<ColorRepository, String> {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());

    protected JSONToColorRepository(DataManager loader) {
        super(loader);
    }

    @Override
    public void convertAndStore(ColorRepository repositoryStore, String input) {
        int loaded = 0;
        JSONObject colorSetJson = new JSONObject(input);
        for (String paletteKey : colorSetJson.keySet()) {
            repositoryStore.add(paletteKey, JSONUtils.toColorPalette(colorSetJson.get(paletteKey)));
            ++loaded;
        }
        this.logger.log(Level.INFO, "Loaded {0} Color Palettes", loaded);
    }

    @Override
    public ColorRepository convert(String json) {
        boolean loaded = false;
        ColorRepository colorSet = new ColorRepository();
        this.convertAndStore(colorSet, json);
        return colorSet;
    }
}

