/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.repository;

import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegionRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegionSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.RepositoryJSONConverter;
import com.neutronio.astrax.io.json.game.generator.JSONToGalaxyRegionSettings;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONObject;

public class JSONToGalaxyRegionRepository
extends RepositoryJSONConverter<GalaxyRegionRepository, String> {
    private JSONToGalaxyRegionSettings galaxyRegionSettingsConverter = null;

    protected JSONToGalaxyRegionRepository(DataManager loader) {
        super(loader);
        this.galaxyRegionSettingsConverter = loader.getConverter(JSONToGalaxyRegionSettings.class);
    }

    @Override
    public GalaxyRegionRepository convert(String input) {
        GalaxyRegionRepository galaxyRegionRepository = new GalaxyRegionRepository();
        this.convertAndStore(galaxyRegionRepository, input);
        return galaxyRegionRepository;
    }

    @Override
    public void convertAndStore(GalaxyRegionRepository repositoryStore, String input) {
        Map<String, Object> regionMap = new JSONObject(input).toMap();
        int loaded = 0;
        for (String regionName : regionMap.keySet()) {
            Map regionProperties = (Map)regionMap.get(regionName);
            GalaxyRegionSettings settings = this.galaxyRegionSettingsConverter.convert(regionProperties);
            settings.id = regionName;
            if (settings != null) {
                repositoryStore.add(regionName, settings);
                ++loaded;
                continue;
            }
            this.logger.log(Level.WARNING, "Could not load Galaxy Region: " + regionName);
        }
        this.logger.log(Level.INFO, "Loaded {0} Galaxy Region Settings", loaded);
    }
}

