/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.repository;

import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.RepositoryJSONConverter;
import com.neutronio.astrax.io.json.game.generator.JSONToOrbitSettings;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONObject;

public class JSONToOrbitRepository
extends RepositoryJSONConverter<OrbitRepository, String> {
    protected JSONToOrbitRepository(DataManager loader) {
        super(loader);
    }

    @Override
    public void convertAndStore(OrbitRepository repositoryStore, String input) {
        int loaded = 0;
        JSONToOrbitSettings orbitConverter = ((DataManager)((Object)this.getLoader())).getConverter(JSONToOrbitSettings.class);
        JSONObject orbitsJSON = new JSONObject(input);
        Map<String, Object> orbitsMap = orbitsJSON.toMap();
        for (String orbitID : orbitsMap.keySet()) {
            Map parameters = (Map)orbitsMap.get(orbitID);
            OrbitSettings orbitSettings = orbitConverter.convert(parameters);
            repositoryStore.add(orbitID, orbitSettings);
            ++loaded;
        }
        this.logger.log(Level.INFO, "Loaded {0} Orbits", loaded);
    }

    @Override
    public OrbitRepository convert(String input) {
        OrbitRepository orbitRepository = new OrbitRepository();
        this.convertAndStore(orbitRepository, input);
        return orbitRepository;
    }
}

