/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.repository;

import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTraitRepository;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.RepositoryJSONConverter;
import com.neutronio.astrax.io.json.game.generator.JSONToPlanetTraits;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONToPlanetTraitsRepository
extends RepositoryJSONConverter<PlanetTraitRepository, String> {
    protected JSONToPlanetTraitsRepository(DataManager loader) {
        super(loader);
    }

    @Override
    public PlanetTraitRepository convert(String input) {
        PlanetTraitRepository traitRepository = new PlanetTraitRepository();
        this.loadTraitList(input, "planetTraits", traitRepository);
        return traitRepository;
    }

    private void loadTraitList(String input, String traitKey, PlanetTraitRepository traitRepository) {
        int loaded = 0;
        JSONToPlanetTraits jsonToPlanetTraits = this.loader.getConverter(JSONToPlanetTraits.class);
        JSONArray objects = new JSONObject(input).getJSONArray(traitKey);
        List<Object> traits = objects.toList();
        for (Object trait : traits) {
            Map traitMap = (Map)trait;
            PlanetTrait planetTrait = jsonToPlanetTraits.convert(traitMap);
            traitRepository.add(planetTrait.id, planetTrait);
            if (planetTrait == null) continue;
            ++loaded;
        }
        this.logger.log(Level.INFO, "Loaded {0} " + traitKey, loaded);
    }

    @Override
    public void convertAndStore(PlanetTraitRepository repositoryStore, String input) {
    }
}

