/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.repository;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettingsRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitalBeltSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.JSONToTree;
import com.neutronio.astrax.io.json.game.RepositoryJSONConverter;
import com.neutronio.astrax.io.json.game.generator.JSONToOrbitalBeltSettings;
import com.neutronio.astrax.util.TargetSettings;
import com.neutronio.astrax.util.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.json.JSONObject;

public class JSONToStarSystemSettingsRepository
extends RepositoryJSONConverter<StarSystemSettingsRepository, String> {
    protected JSONToStarSystemSettingsRepository(DataManager loader) {
        super(loader);
    }

    @Override
    public void convertAndStore(StarSystemSettingsRepository repositoryStore, String input) {
        int loaded = 0;
        JSONToTree jsonToTreeConverter = ((DataManager)((Object)this.getLoader())).getConverter(JSONToTree.class);
        JSONToOrbitalBeltSettings jsonToOrbitalBeltSettings = ((DataManager)((Object)this.getLoader())).getConverter(JSONToOrbitalBeltSettings.class);
        JSONObject systemJSON = new JSONObject(input);
        for (Map.Entry<String, Object> entry : systemJSON.toMap().entrySet()) {
            Map starSystemMap = (Map)entry.getValue();
            String id = (String)starSystemMap.get("id");
            if (id == null) {
                throw new AstraXException(AstraXException.ErrorCode.E2005, "id");
            }
            String name = (String)starSystemMap.get("name");
            if (name == null) {
                throw new AstraXException(AstraXException.ErrorCode.E2005, "name");
            }
            Boolean excluded = (Boolean)starSystemMap.get("excludeFromGeneration");
            if (!Objects.equals(id, entry.getKey())) {
                this.logger.severe("Error creating StarSystem because StarSystem.id " + id + " does not match Map-key '" + entry.getKey() + "'. System is ignored!");
                continue;
            }
            Map planetMap = (Map)starSystemMap.get("systemMembers");
            Tree<TargetSettings> convertedTree = jsonToTreeConverter.convert(planetMap);
            List beltSettings = (List)starSystemMap.get("beltSettings");
            if (beltSettings == null) {
                this.logger.log(Level.WARNING, "No Belt Settings specified in StarSystem: " + name);
            }
            ArrayList<OrbitalBeltSettings> beltSettingsList = new ArrayList<OrbitalBeltSettings>();
            for (Map beltSetting : beltSettings) {
                OrbitalBeltSettings orbitalBeltSettings = jsonToOrbitalBeltSettings.convert(beltSetting);
                beltSettingsList.add(orbitalBeltSettings);
            }
            StarSystemSettings systemSettings = new StarSystemSettings();
            systemSettings.setId(id);
            systemSettings.setName(name);
            systemSettings.setExcludeFromGeneration(excluded);
            if (starSystemMap.containsKey("icon")) {
                systemSettings.icon = (String)starSystemMap.get("icon");
            }
            systemSettings.setSystemMembers(convertedTree);
            systemSettings.setBeltSettings(beltSettingsList);
            repositoryStore.add(systemSettings.getId(), systemSettings);
            ++loaded;
        }
        this.logger.log(Level.INFO, "Loaded {0} Star Systems", loaded);
    }

    @Override
    public StarSystemSettingsRepository convert(String json) {
        StarSystemSettingsRepository repository = new StarSystemSettingsRepository();
        this.convertAndStore(repository, json);
        return repository;
    }
}

