/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.sql;

import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidData;
import com.neutronio.astrax.io.sql.GameDatabase;
import com.neutronio.astrax.io.sql.GeneralDAO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class AsteroidDAO
implements GeneralDAO<AsteroidData> {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    public static final String createTableSQL = "create table Asteroids (\n     [id] integer primary key,\n     [sectorId] integer,\n     [entityId] varchar(30),\n     [remainingDeposit] integer);";
    public static final String updateSQL = "update Asteroids     set remainingDeposit = ?      where entityId = ?;";
    public static final String insertSQL = "insert into Asteroids (sectorId,entityId, remainingDeposit)  values(?, ?, ?);";
    public static final String selectSQL = "select remainingDeposit from Asteroids where entityId = ?;";
    public static final String selectSQLBySector = "select entityId, remainingDeposit from Asteroids where sectorId = ?;";
    public static final String existsSQL = "select true from Asteroids where entityId = ?;";
    public static final String removeSQL = "delete from Asteroids where entityId = ?;";
    private GameDatabase gameDatabase;

    public AsteroidDAO(GameDatabase gameDatabase) {
        this.gameDatabase = gameDatabase;
    }

    @Override
    public boolean exists(int id) throws SQLException {
        throw new UnsupportedOperationException("Not supported! Please check exists by EntityID instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String entityId) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(existsSQL);
            preparedStatement.setString(1, entityId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.isBeforeFirst()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = resultSet.getBoolean(1);
            return bl;
        }
        return false;
    }

    @Override
    public AsteroidData get(int id) throws SQLException {
        throw new UnsupportedOperationException("Not supported! Please get by EntityID instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsteroidData> getAll(int sectorId) throws SQLException {
        this.logger.finest("Loading Asteroids of sector ID " + sectorId);
        ArrayList<AsteroidData> asteroidData = new ArrayList<AsteroidData>();
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(selectSQLBySector);
            preparedStatement.setInt(1, sectorId);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                AsteroidData asteroid = new AsteroidData();
                asteroid.entityID = resultSet.getString(1);
                asteroid.remainingDeposit = resultSet.getInt(2);
                asteroidData.add(asteroid);
            }
        }
        return asteroidData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsteroidData getByEntityID(String entityId) throws SQLException {
        this.logger.finest("Loading Asteroid of entity ID " + entityId);
        AsteroidData asteroidData = null;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(selectSQL);
            preparedStatement.setString(1, entityId);
            ResultSet resultSet = preparedStatement.executeQuery();
            asteroidData = new AsteroidData();
            asteroidData.remainingDeposit = resultSet.getInt(1);
            AsteroidData asteroidData2 = asteroidData;
            return asteroidData2;
        }
        return asteroidData;
    }

    @Override
    public void remove(int id) throws SQLException {
        throw new UnsupportedOperationException("Not supported! Please remove by EntityID instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String entityID) throws SQLException {
        this.logger.finest("Removing Asteroid of ID " + entityID);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(removeSQL);
            preparedStatement.setString(1, entityID);
            preparedStatement.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAll(Collection<AsteroidData> asteroids) throws SQLException {
        try (Statement preparedStatement = null;){
            int count = 0;
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertSQL);
            for (AsteroidData asteroidData : asteroids) {
                preparedStatement.setInt(1, asteroidData.sectorId);
                preparedStatement.setString(2, asteroidData.entityID);
                preparedStatement.setFloat(3, asteroidData.remainingDeposit);
                preparedStatement.execute();
                ++count;
            }
            this.logger.finest(count + " Asteroids inserted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(AsteroidData object) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertSQL);
            preparedStatement.setInt(1, object.sectorId);
            preparedStatement.setString(2, object.entityID);
            preparedStatement.setFloat(3, object.remainingDeposit);
            preparedStatement.execute();
            this.logger.finest("New Asteroid inserted for entity " + object.entityID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(AsteroidData object) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateSQL);
            preparedStatement.setFloat(1, object.remainingDeposit);
            preparedStatement.setString(2, object.entityID);
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, Asteroid was not updated!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAll(List<AsteroidData> asteroids) throws SQLException {
        try (Statement preparedStatement = null;){
            int count = 0;
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateSQL);
            for (AsteroidData asteroidData : asteroids) {
                preparedStatement.setFloat(1, asteroidData.remainingDeposit);
                preparedStatement.setString(2, asteroidData.entityID);
                int affectedRows = preparedStatement.executeUpdate();
                if (affectedRows == 0) {
                    this.logger.warning("No rows affected, Asteroid was not updated!");
                    continue;
                }
                ++count;
            }
            this.logger.finest(count + " Asteroids updated");
        }
    }
}

