/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.sql;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.io.sql.GameDatabase;
import com.neutronio.astrax.io.sql.GeneralDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class DiscoveryDAO
implements GeneralDAO<Discovery> {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    public static final String createTableSQL = "create table Discovery (\n     [discoveryId] integer primary key,\n     [sectorId] integer not null,\n     [parentId] integer,\n     [entityId] varchar(30),\n     [rarity] short,\n     [classification] short not null,\n     [icon] varchar(30),\n     [name] varchar(30),\n     [description] varchar(500),\n     [points] integer\n);";
    public static final String createChildDiscoveryTableSQL = "create table ChildDiscovery (\n     [id] integer primary key,\n     [discoveryId] integer,\n     [archetypeId] varchar(30)\n);";
    public static final String createChildDiscoveryIndexSQL = "create index ChildDiscovery_Index_DiscoveryId on ChildDiscovery(discoveryId);";
    public static final String insertChildDiscoverySql = "insert into ChildDiscovery (\n     discoveryId,\n     archetypeId\n) values(?, ?);";
    public static final String existsChildDiscoverySql = "select true from ChildDiscovery where discoveryId = ? and archetypeId = ?;";
    public static final String selectChildDiscoverySql = "select archetypeId from ChildDiscovery\n     where discoveryId = ?;";
    public static final String updateSQL = "update Discovery     set icon = ?,      name = ?,      description = ?     where discoveryId = ?;";
    public static final String insertSQL = "insert into Discovery (discoveryId, sectorId, parentId, entityId, rarity, classification, icon, name, description, points)  values( ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    public static final String insertSQLNoParent = "insert into Discovery (discoveryId, sectorId, entityId, rarity, classification, icon, name, description, points)  values( ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    public static final String selectSQL = "select discoveryId, sectorId, parentId, entityId, rarity, classification, icon, name, description,points from Discovery where discoveryId = ?;";
    public static final String countDiscoveriesSQL = "select count(*) from Discovery where sectorId = ?";
    public static final String selectSQLbyEntityId = "select discoveryId, sectorId, parentId, entityId, rarity, classification, icon, name, description,points from Discovery where entityId = ?;";
    public static final String selectSQLbySector = "select discoveryId, sectorId, parentId, entityId, rarity, classification, icon, name, description,points from Discovery where sectorId = ? ";
    public static final String removeSQL = "delete from Discovery where discoveryId = ?;";
    public static final String existsSQL = "select true from Discovery where discoveryId = ?;";
    private GameDatabase gameDatabase;

    public DiscoveryDAO(GameDatabase gameDatabase) {
        this.gameDatabase = gameDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(int id) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(existsSQL);
            preparedStatement.setInt(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.isBeforeFirst()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = resultSet.getBoolean(1);
            return bl;
        }
        return false;
    }

    public Map<String, Discovery> get(EntityID ... ids) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discovery> getBySectorId(int sectorId, int classification) throws SQLException {
        this.logger.finest("Loading Discovery of sector ID " + sectorId);
        ArrayList<Discovery> discoveries = new ArrayList<Discovery>();
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement("select discoveryId, sectorId, parentId, entityId, rarity, classification, icon, name, description,points from Discovery where sectorId = ?  and classification = ?;");
            preparedStatement.setInt(1, sectorId);
            preparedStatement.setInt(2, classification);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Discovery discovery = new Discovery();
                discovery.id = resultSet.getInt(1);
                discovery.starSystemId = resultSet.getInt(2);
                discovery.parentId = resultSet.getInt(3);
                discovery.entityId = resultSet.getString(4);
                discovery.rarity = Discovery.Rarity.values()[resultSet.getShort(5)];
                discovery.classification = Discovery.Classification.values()[resultSet.getShort(6)];
                discovery.icon = resultSet.getString(7);
                discovery.name = resultSet.getString(8);
                discovery.description = resultSet.getString(9);
                discovery.discoveryPoints = resultSet.getInt(10);
                discoveries.add(discovery);
            }
        }
        return discoveries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Discovery> getByFilter(int sectorId, int ... classifications) throws SQLException {
        this.logger.finest("Loading Discovery of sector ID " + sectorId);
        LinkedHashMap<String, Discovery> discoveries = new LinkedHashMap<String, Discovery>();
        try (Statement preparedStatement = null;){
            StringBuilder statement = new StringBuilder(selectSQLbySector);
            this.appendClassificationWhereStatement(statement, classifications.length);
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(statement.toString());
            preparedStatement.setInt(1, sectorId);
            for (int i2 = 0; i2 < classifications.length; ++i2) {
                preparedStatement.setInt(i2 + 2, classifications[i2]);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Discovery discovery = new Discovery();
                discovery.id = resultSet.getInt(1);
                discovery.starSystemId = resultSet.getInt(2);
                discovery.parentId = resultSet.getInt(3);
                discovery.entityId = resultSet.getString(4);
                discovery.rarity = Discovery.Rarity.values()[resultSet.getShort(5)];
                discovery.classification = Discovery.Classification.values()[resultSet.getShort(6)];
                discovery.icon = resultSet.getString(7);
                discovery.name = resultSet.getString(8);
                discovery.description = resultSet.getString(9);
                discovery.discoveryPoints = resultSet.getInt(10);
                discoveries.put(discovery.entityId, discovery);
            }
        }
        return discoveries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean childDiscoveryExists(int discoveryId, String archetypeId) throws SQLException {
        boolean result = false;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(existsChildDiscoverySql);
            preparedStatement.setInt(1, discoveryId);
            preparedStatement.setString(2, archetypeId);
            ResultSet resultSet = preparedStatement.executeQuery();
            result = !resultSet.isBeforeFirst() ? false : resultSet.getBoolean(1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildDiscoveriesFor(int discoveryId) throws SQLException {
        ArrayList<String> childDiscoveryIds = new ArrayList<String>();
        this.logger.finest("Loading Child Discoveries for discovery ID " + discoveryId);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(selectChildDiscoverySql);
            preparedStatement.setInt(1, discoveryId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.isBeforeFirst()) {
                ArrayList<String> arrayList = childDiscoveryIds;
                return arrayList;
            }
            while (resultSet.next()) {
                childDiscoveryIds.add(resultSet.getString(1));
            }
        }
        return childDiscoveryIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildDiscoveryTo(int discoveryId, String objectId) throws SQLException {
        this.logger.finest("Adding Child Discovery to discovery ID " + discoveryId);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertChildDiscoverySql);
            preparedStatement.setInt(1, discoveryId);
            preparedStatement.setString(2, objectId);
            preparedStatement.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Discovery getByEntityId(String entityId) throws SQLException {
        this.logger.finest("Loading Discovery of entity ID " + entityId);
        Discovery discovery = null;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(selectSQLbyEntityId);
            preparedStatement.setString(1, entityId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.isBeforeFirst()) {
                discovery = new Discovery();
                discovery.id = resultSet.getInt(1);
                discovery.starSystemId = resultSet.getInt(2);
                discovery.parentId = resultSet.getInt(3);
                discovery.entityId = resultSet.getString(4);
                discovery.rarity = Discovery.Rarity.values()[resultSet.getShort(5)];
                discovery.classification = Discovery.Classification.values()[resultSet.getShort(6)];
                discovery.icon = resultSet.getString(7);
                discovery.name = resultSet.getString(8);
                discovery.description = resultSet.getString(9);
                discovery.discoveryPoints = resultSet.getInt(10);
            }
        }
        return discovery;
    }

    public int getDiscoveryCount(int sectorId) {
        PreparedStatement preparedStatement = null;
        int count = 0;
        try {
            StringBuilder statement = new StringBuilder("select count(*) from Discovery where sectorId = ?;");
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(statement.toString());
            preparedStatement.setInt(1, sectorId);
            ResultSet resultSet = preparedStatement.executeQuery();
            count = resultSet.getInt(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    public int getDiscoveryCount(int sectorId, int ... classifications) {
        PreparedStatement preparedStatement = null;
        int count = 0;
        try {
            StringBuilder statement = new StringBuilder(countDiscoveriesSQL);
            this.appendClassificationWhereStatement(statement, classifications.length);
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(statement.toString());
            preparedStatement.setInt(1, sectorId);
            int index = 2;
            for (int classification : classifications) {
                preparedStatement.setInt(index, classification);
                ++index;
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            count = resultSet.getInt(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Discovery get(int id) throws SQLException {
        this.logger.finest("Loading Discovery of ID " + id);
        Discovery discovery = null;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(selectSQL);
            preparedStatement.setInt(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.isBeforeFirst()) {
                discovery = new Discovery();
                discovery.id = resultSet.getInt(1);
                discovery.starSystemId = resultSet.getInt(2);
                discovery.parentId = resultSet.getInt(3);
                discovery.entityId = resultSet.getString(4);
                discovery.rarity = Discovery.Rarity.values()[resultSet.getShort(5)];
                discovery.classification = Discovery.Classification.values()[resultSet.getShort(6)];
                discovery.icon = resultSet.getString(7);
                discovery.name = resultSet.getString(8);
                discovery.description = resultSet.getString(9);
                discovery.discoveryPoints = resultSet.getInt(10);
            }
        }
        return discovery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int id) throws SQLException {
        this.logger.finest("Removing Discovery of ID " + id);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(removeSQL);
            preparedStatement.setInt(1, id);
            preparedStatement.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Discovery object) throws SQLException {
        Statement preparedStatement = null;
        if (object.starSystemId == null && (Objects.equals((Object)object.classification, (Object)Discovery.Classification.STAR) || Objects.equals((Object)object.classification, (Object)Discovery.Classification.ASTEROID) || Objects.equals((Object)object.classification, (Object)Discovery.Classification.BELT))) {
            throw new AstraXException(AstraXException.ErrorCode.E2001, "StarSystemID expected for this classification: " + (Object)((Object)object.classification));
        }
        try {
            if (object.parentId == null) {
                preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertSQLNoParent);
                preparedStatement.setInt(1, object.id);
                preparedStatement.setInt(2, object.starSystemId == null ? -1 : object.starSystemId);
                preparedStatement.setString(3, object.entityId);
                preparedStatement.setShort(4, (short)object.rarity.ordinal());
                preparedStatement.setShort(5, (short)object.classification.ordinal());
                preparedStatement.setString(6, object.icon);
                preparedStatement.setString(7, object.name);
                preparedStatement.setString(8, object.description);
                preparedStatement.setInt(9, object.discoveryPoints);
                preparedStatement.execute();
            } else {
                preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertSQL);
                preparedStatement.setInt(1, object.id);
                preparedStatement.setInt(2, object.starSystemId);
                preparedStatement.setInt(3, object.parentId);
                preparedStatement.setString(4, object.entityId);
                preparedStatement.setShort(5, (short)object.rarity.ordinal());
                preparedStatement.setShort(6, (short)object.classification.ordinal());
                preparedStatement.setString(7, object.icon);
                preparedStatement.setString(8, object.name);
                preparedStatement.setString(9, object.description);
                preparedStatement.setInt(10, object.discoveryPoints);
                preparedStatement.execute();
            }
            this.logger.finest("New Discovery inserted with id " + object.id);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Discovery object) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateSQL);
            preparedStatement.setString(1, object.icon);
            preparedStatement.setString(2, object.name);
            preparedStatement.setString(3, object.description);
            preparedStatement.setInt(4, object.id);
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, discovery was not updated!");
            }
        }
    }

    private StringBuilder appendClassificationWhereStatement(StringBuilder statement, int count) {
        statement.append("and (");
        for (int i2 = 0; i2 < count; ++i2) {
            statement.append("classification = ?");
            if (i2 == count - 1) continue;
            statement.append("\nor ");
        }
        statement.append(");");
        return statement;
    }
}

