/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.sql;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegion;
import com.neutronio.astrax.io.sql.GameDatabase;
import com.neutronio.astrax.io.sql.MapDAO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

public class GalaxyRegionDAO
implements MapDAO<GalaxyRegion> {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private static String loadSQL = "select regionId, settingsId, name, regionColor from GalaxyRegions where regionId = ?;";
    private static String loadByLocationSQL2 = "select distinct GalaxyRegions.regionId, GalaxyRegions.settingsId, GalaxyRegions.name,GalaxyRegions.regionColor from StarSystems inner join GalaxyRegions on StarSystems.regionId = GalaxyRegions.regionId and StarSystems.x = ? and StarSystems.y = ? and (StarSystems.regionId > -1 or StarSystems.regionId not null);";
    private static String updateSQL = "update GalaxyRegions set settingsId = ?, name = ?, regionColor = ?where regionId = ?;";
    private static String insertSQL = "insert into GalaxyRegions (regionId, settingsId, name, regionColor) values(?, ?, ?, ?);";
    private static String removeSQL = "delete from GalaxyRegions where regionId == ?;";
    private static String existsSQL = "select true from GalaxyRegions where regionId = ?";
    private GameDatabase gameDatabase;

    public GalaxyRegionDAO(GameDatabase gameDatabase) {
        this.gameDatabase = gameDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(int id) throws SQLException {
        boolean result = false;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(existsSQL);
            preparedStatement.setInt(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            result = !resultSet.isBeforeFirst() ? false : resultSet.getBoolean(1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GalaxyRegion get(int id) throws SQLException {
        this.logger.finest("Loading Galaxy Region of ID " + id);
        GalaxyRegion galaxyRegion = null;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(loadSQL);
            preparedStatement.setInt(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.isBeforeFirst()) {
                galaxyRegion = new GalaxyRegion();
                galaxyRegion.setId(resultSet.getInt(1));
                galaxyRegion.setSettingsId(resultSet.getString(2));
                galaxyRegion.setRegionName(resultSet.getString(3));
                galaxyRegion.setRegionColor(new Color(resultSet.getInt(4)));
            }
        }
        return galaxyRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GalaxyRegion getByLocation(int x, int y) throws SQLException {
        this.logger.finest("Loading Galaxy Region @ location " + x + " " + y);
        GalaxyRegion galaxyRegion = null;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(loadByLocationSQL2);
            preparedStatement.setShort(1, (short)x);
            preparedStatement.setShort(2, (short)y);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.isBeforeFirst()) {
                galaxyRegion = new GalaxyRegion();
                galaxyRegion.setId(resultSet.getInt(1));
                galaxyRegion.setSettingsId(resultSet.getString(2));
                galaxyRegion.setRegionName(resultSet.getString(3));
                galaxyRegion.setRegionColor(new Color(resultSet.getInt(4)));
            }
        }
        return galaxyRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int id) throws SQLException {
        this.logger.finest("Removing Galaxy Region of ID " + id);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(removeSQL);
            preparedStatement.setInt(1, id);
            preparedStatement.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(GalaxyRegion object) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertSQL);
            preparedStatement.setInt(1, object.getId());
            preparedStatement.setString(2, object.getSettingsId());
            preparedStatement.setString(3, object.getRegionName());
            preparedStatement.setInt(4, Color.rgba8888(object.getRegionColor()));
            preparedStatement.execute();
            this.logger.finest("New Galaxy Region inserted with id " + object.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(GalaxyRegion object) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateSQL);
            preparedStatement.setString(1, object.getSettingsId());
            preparedStatement.setString(2, object.getRegionName());
            preparedStatement.setFloat(3, Color.rgba8888(object.getRegionColor()));
            preparedStatement.setInt(4, object.getId());
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, galaxy region was not updated!");
            }
        }
    }
}

