/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.sql;

import com.neutronio.astrax.io.sql.MerchantDAO;
import com.neutronio.astrax.io.sql.SatelliteDAO;
import com.neutronio.astrax.io.sql.StarSystemHeaderDAO;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

public class GameDatabase {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private String url;
    private Connection connection;
    private static String createBlobTableSQL = "    create table Blob (\n            [blobId] integer primary key,\n            [data] blob(30000)    );";
    private static String createGalaxyRegionTableSQL = "    create table GalaxyRegions (\n            [regionId] integer primary key,\n            [settingsId] varchar(30),\n            [name] varchar(25),\n            [regionColor] integer    );";

    public GameDatabase(String url) {
        this.url = url;
    }

    public void openConnection() {
        try {
            this.connection = DriverManager.getConnection(this.url);
            if (this.connection != null) {
                DatabaseMetaData metaData = this.connection.getMetaData();
                this.logger.info("Database connected successfully.");
                this.logger.info("The driver name is " + metaData.getDriverName());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void closeConnection() {
        try {
            this.connection.close();
            this.logger.info("Database closed connection.");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createTables() {
        this.logger.info("Setting up tables...");
        try {
            Statement statement = this.connection.createStatement();
            statement.execute(createGalaxyRegionTableSQL);
            statement.execute(StarSystemHeaderDAO.createStarSystemTableSQL);
            statement.execute(SatelliteDAO.createTableSQL);
            statement.execute("create table Asteroids (\n     [id] integer primary key,\n     [sectorId] integer,\n     [entityId] varchar(30),\n     [remainingDeposit] integer);");
            statement.execute("create table Discovery (\n     [discoveryId] integer primary key,\n     [sectorId] integer not null,\n     [parentId] integer,\n     [entityId] varchar(30),\n     [rarity] short,\n     [classification] short not null,\n     [icon] varchar(30),\n     [name] varchar(30),\n     [description] varchar(500),\n     [points] integer\n);");
            statement.execute("create table ChildDiscovery (\n     [id] integer primary key,\n     [discoveryId] integer,\n     [archetypeId] varchar(30)\n);");
            statement.execute("create index ChildDiscovery_Index_DiscoveryId on ChildDiscovery(discoveryId);");
            statement.execute("create table NavigationBookmarks (\n     [id] integer primary key,\n     [sectorId] integer,\n     [entityId] varchar(30) unique,\n     [isTracked] boolean,\n     [icon] varchar(30),\n     [name] varchar(30),\n     [color] integer);");
            statement.execute(MerchantDAO.createTableSQL);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

