/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.sql;

import com.neutronio.astrax.app.datapack.game.world.Merchant;
import com.neutronio.astrax.io.sql.GameDatabase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

public class MerchantDAO {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    public static String createTableSQL = "    create table Merchant (\n            [entityId] varchar(30) primary key,\n            [name] varchar(25),\n            [currentMoney] float(3, 5) not null,\n            [lastRestock] date(3, 1),\n            [sellPriceModifier] float(3, 5) not null,\n            [buyPriceModifier] float(3, 5) not null\n    );";
    private static String loadByIdSQL = "select entityId, name, currentMoney, lastRestock, sellPriceModifier, buyPriceModifier from Merchant where entityId == ?";
    private static String loadBySatelliteIdSQL = "select entityId, name, currentMoney, lastRestock, sellPriceModifier, buyPriceModifier from Merchant where entityId == ?";
    private static String updateSQL = "update Merchant set name = ?, currentMoney = ?, lastRestock = ?, sellPriceModifier = ?, buyPriceModifier = ? where entityId == ?";
    private static String insertSQL = "insert into Merchant (entityId, name, currentMoney, lastRestock, sellPriceModifier, buyPriceModifier) values ( ?, ?, ?, ?, ?, ?);";
    private static String removeSQL = "delete from Merchant where entityId == ?";
    private static String existsSQL = "select true from Merchant where entityId == ?";
    private GameDatabase gameDatabase;

    public MerchantDAO(GameDatabase gameDatabase) {
        this.gameDatabase = gameDatabase;
    }

    public boolean exists(String entityId) throws SQLException {
        return this._exists(entityId, existsSQL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _exists(String id, String statement) throws SQLException {
        boolean exists = false;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(statement);
            preparedStatement.setString(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            exists = resultSet.getBoolean(1);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Merchant get(String entityId) throws SQLException {
        this.logger.finest("Loading Trader of entityId " + entityId);
        Merchant merchant = null;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(loadByIdSQL);
            preparedStatement.setString(1, entityId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.isBeforeFirst()) {
                merchant = new Merchant();
                merchant.entityId = resultSet.getString(1);
                merchant.name = resultSet.getString(2);
                merchant.currentMoney = resultSet.getFloat(3);
                merchant.sellPriceModifier = resultSet.getFloat(5);
                merchant.buyPriceModifier = resultSet.getFloat(6);
            }
        }
        return merchant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String entityId) throws SQLException {
        this.logger.finest("Removing Merchant of ID " + entityId);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(removeSQL);
            preparedStatement.setString(1, entityId);
            preparedStatement.execute();
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Merchant merchant) throws SQLException {
        this.logger.finest("Inserting new merchant for entity ID " + merchant.entityId);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertSQL);
            preparedStatement.setString(1, merchant.entityId);
            preparedStatement.setString(2, merchant.name);
            preparedStatement.setFloat(3, merchant.currentMoney);
            preparedStatement.setFloat(5, merchant.sellPriceModifier);
            preparedStatement.setFloat(6, merchant.buyPriceModifier);
            preparedStatement.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Merchant merchant) throws SQLException {
        this.logger.finest("Updating Star System of entityId " + merchant.entityId);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateSQL);
            preparedStatement.setString(1, merchant.name);
            preparedStatement.setFloat(2, merchant.currentMoney);
            preparedStatement.setFloat(4, merchant.sellPriceModifier);
            preparedStatement.setFloat(5, merchant.buyPriceModifier);
            preparedStatement.setString(6, merchant.entityId);
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, system was not updated!");
            }
        }
    }
}

