/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.sql;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.io.sql.GameDatabase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class NavigationBookmarkDAO {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    public static final String createTableSQL = "create table NavigationBookmarks (\n     [id] integer primary key,\n     [sectorId] integer,\n     [entityId] varchar(30) unique,\n     [isTracked] boolean,\n     [icon] varchar(30),\n     [name] varchar(30),\n     [color] integer);";
    public static final String updateSQL = "update NavigationBookmarks     set icon = ?,      name = ?,     color = ?,     isTracked = ?     where entityId = ?;";
    public static final String updateFlagSQL = "update NavigationBookmarks     set isTracked = ?     where entityId = ?;";
    public static final String insertSQL = "insert into NavigationBookmarks (sectorId,entityId, icon, name, color,isTracked)  values(?, ?, ?, ?, ?, ?);";
    public static final String selectSQL = "select entityId, icon, name, color, isTracked from NavigationBookmarks where entityId = ?;";
    public static final String selectBySectorId = "select entityId, icon, name, color,isTracked from NavigationBookmarks where sectorId = ?;";
    public static final String selectAllSQL = "select sectorId, entityId, icon, name, color,isTracked from NavigationBookmarks;";
    public static final String existsSQL = "select true from NavigationBookmarks where entityId = ?;";
    public static final String removeSQL = "delete from NavigationBookmarks where entityId = ?;";
    private GameDatabase gameDatabase;

    public NavigationBookmarkDAO(GameDatabase gameDatabase) {
        this.gameDatabase = gameDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String entityId) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(existsSQL);
            preparedStatement.setString(1, entityId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.isBeforeFirst()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = resultSet.getBoolean(1);
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigationBookmark get(String entityId) throws SQLException {
        NavigationBookmark bookmark = null;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(selectSQL);
            preparedStatement.setString(1, entityId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.isBeforeFirst()) {
                bookmark = new NavigationBookmark();
                bookmark.entityId = resultSet.getString(1);
                bookmark.icon = resultSet.getString(2);
                bookmark.name = resultSet.getString(3);
                bookmark.color = new Color(resultSet.getInt(4));
                bookmark.isTracked = resultSet.getBoolean(5);
            }
        }
        return bookmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NavigationBookmark> getAll(int sectorId) throws SQLException {
        this.logger.finest("Loading NavigationBookmarks for sector ID " + sectorId);
        HashMap<String, NavigationBookmark> bookmarks = new HashMap<String, NavigationBookmark>();
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(selectBySectorId);
            preparedStatement.setInt(1, sectorId);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                NavigationBookmark bookmark = new NavigationBookmark();
                bookmark.entityId = resultSet.getString(1);
                bookmark.icon = resultSet.getString(2);
                bookmark.name = resultSet.getString(3);
                bookmark.color = new Color(resultSet.getInt(4));
                bookmark.isTracked = resultSet.getBoolean(5);
                bookmarks.put(bookmark.entityId, bookmark);
            }
        }
        return bookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NavigationBookmark> getAll() throws SQLException {
        this.logger.finest("Loading all NavigationBookmarks...");
        HashMap<String, NavigationBookmark> bookmarks = new HashMap<String, NavigationBookmark>();
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(selectAllSQL);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                NavigationBookmark bookmark = new NavigationBookmark();
                bookmark.sectorId = resultSet.getInt(1);
                bookmark.entityId = resultSet.getString(2);
                bookmark.icon = resultSet.getString(3);
                bookmark.name = resultSet.getString(4);
                bookmark.color = new Color(resultSet.getInt(5));
                bookmark.isTracked = resultSet.getBoolean(6);
                bookmarks.put(bookmark.entityId, bookmark);
            }
        }
        return bookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String entityId) throws SQLException {
        this.logger.finest("Removing NavigationBookmark for entity ID " + entityId);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(removeSQL);
            preparedStatement.setString(1, entityId);
            preparedStatement.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int sectorId, NavigationBookmark object) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertSQL);
            preparedStatement.setInt(1, sectorId);
            preparedStatement.setString(2, object.entityId);
            preparedStatement.setString(3, object.icon);
            preparedStatement.setString(4, object.name);
            preparedStatement.setInt(5, Color.rgba8888(object.color));
            preparedStatement.setBoolean(6, object.isTracked);
            preparedStatement.execute();
            this.logger.finest("New NavigationBookmark inserted for entity " + object.entityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrackedFlag(String entityId, boolean flag) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateFlagSQL);
            preparedStatement.setBoolean(1, flag);
            preparedStatement.setString(2, entityId);
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, NavigationBookmark was not updated!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(NavigationBookmark object) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateSQL);
            preparedStatement.setString(1, object.icon);
            preparedStatement.setString(2, object.name);
            preparedStatement.setInt(3, Color.rgba8888(object.color));
            preparedStatement.setBoolean(4, object.isTracked);
            preparedStatement.setString(5, object.entityId);
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, NavigationBookmark was not updated!");
            }
        }
    }
}

