/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.sql;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteHeader;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedSatellite;
import com.neutronio.astrax.io.sql.GameDatabase;
import com.neutronio.astrax.io.sql.GeneralDAO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

public class SatelliteDAO
implements GeneralDAO<SatelliteHeader> {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private GameDatabase gameDatabase;
    public static String createTableSQL = "    create table Satellite (\n            [satelliteId] integer primary key,\n            [parentSatelliteId] integer,\n            [uuid] varchar(30) not null,\n            [name] varchar(25) not null,\n            [modelName] varchar(25),\n            [x] integer not null,            [y] integer not null,            [rotation] integer not null,            [data] blob(30000)    );";
    private static String loadSQL = "select satelliteId, parentSatelliteId, uuid, name, modelName, x, y, rotation from Satellite where satelliteId = ?;";
    private static String updateSQL = "update Satellite set name = ?, modelName = ? , x = ?, y = ?, rotation = ? where satelliteId = ?;";
    private static String updateDockingSQL = "update Satellite set parentSatelliteId = ? where satelliteId = ?;";
    private static String insertSQL = "insert into Satellite (satelliteId, uuid, name, modelName, x, y, rotation) values( ?, ?, ?, ?, ?, ?, ?);";
    private static String removeSQL = "delete from Satellite where satelliteId = ?;";
    private static String existsSQL = "select true from Satellite where satelliteId = ?";
    private static String updateBinarySQL = "update Satellite set data = ? where satelliteId = ?;";
    private static String getBinarySQL = "select data from Satellite where satelliteId = ?;";

    public SatelliteDAO(GameDatabase gameDatabase) {
        this.gameDatabase = gameDatabase;
    }

    public SatelliteHeader getByEntityID(String entityId) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(int id) throws SQLException {
        boolean exists = false;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(existsSQL);
            preparedStatement.setInt(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            exists = !resultSet.isBeforeFirst() ? false : resultSet.getBoolean(1);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SatelliteHeader get(int id) throws SQLException {
        this.logger.finest("Loading Satellite Header of ID " + id);
        SatelliteHeader satellite = null;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(loadSQL);
            preparedStatement.setInt(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.isBeforeFirst()) {
                satellite = new SatelliteHeader();
                satellite.satelliteId = resultSet.getInt(1);
                satellite.parentSatelliteId = resultSet.getInt(2);
                satellite.uuid = resultSet.getString(3);
                satellite.name = resultSet.getString(4);
                satellite.modelName = resultSet.getString(5);
                satellite.x = resultSet.getInt(6);
                satellite.y = resultSet.getInt(7);
                satellite.rotation = resultSet.getInt(8);
            }
        }
        return satellite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int id) throws SQLException {
        this.logger.finest("Removing Satellite Header of ID " + id);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(removeSQL);
            preparedStatement.setInt(1, id);
            preparedStatement.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(SatelliteHeader object) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertSQL);
            preparedStatement.setInt(1, object.satelliteId);
            preparedStatement.setString(2, object.uuid);
            preparedStatement.setString(3, object.name);
            preparedStatement.setString(4, object.modelName);
            preparedStatement.setInt(5, object.x);
            preparedStatement.setInt(6, object.y);
            preparedStatement.setInt(7, object.rotation);
            preparedStatement.execute();
            this.logger.finest("New Satellite Header inserted with id " + object.satelliteId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(SatelliteHeader object) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateSQL, 1);
            preparedStatement.setString(1, object.name);
            preparedStatement.setString(2, object.modelName);
            preparedStatement.setInt(3, object.x);
            preparedStatement.setInt(4, object.y);
            preparedStatement.setInt(5, object.rotation);
            preparedStatement.setInt(6, object.satelliteId);
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, satellite header was not updated!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDockedParent(int satelliteId, Integer parentSatelliteId) throws SQLException {
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateDockingSQL, 1);
            preparedStatement.setInt(1, parentSatelliteId);
            preparedStatement.setInt(2, satelliteId);
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, satellite header was not updated!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeBinary(int satelliteId, SavedSatellite satellite) throws SQLException {
        if (satellite == null) {
            throw new AstraXException(AstraXException.ErrorCode.E2001, "SavedSatellite is null! If you wish to delete this binary, the whole header must be deleted!");
        }
        Statement preparedStatement = null;
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(satellite);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AstraXException(AstraXException.ErrorCode.E2001, "Satellite ID " + satelliteId);
        }
        try {
            byte[] bytes = bos.toByteArray();
            this.logger.fine("Storing binary of length: " + bytes.length);
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateBinarySQL);
            preparedStatement.setBytes(1, bytes);
            preparedStatement.setInt(2, satelliteId);
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, spacecraft blob was not updated!");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SavedSatellite getBinary(int satelliteId) throws SQLException, AstraXException {
        SavedSatellite savedSatellite;
        block10: {
            savedSatellite = null;
            try (Statement preparedStatement = null;){
                preparedStatement = this.gameDatabase.getConnection().prepareStatement(getBinarySQL);
                preparedStatement.setInt(1, satelliteId);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.isBeforeFirst()) {
                    InputStream binaryStream = resultSet.getBinaryStream(1);
                    ObjectInputStream ois = new ObjectInputStream(binaryStream);
                    savedSatellite = (SavedSatellite)ois.readObject();
                    break block10;
                }
                throw new AstraXException(AstraXException.ErrorCode.E2000, "No binary found for the specified satelliteId: " + satelliteId);
            }
        }
        return savedSatellite;
    }
}

