/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.sql;

import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetType;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemHeader;
import com.neutronio.astrax.io.sql.GameDatabase;
import com.neutronio.astrax.io.sql.MapDAO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class StarSystemHeaderDAO
implements MapDAO<StarSystemHeader> {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    public static String createStarSystemTableSQL = "    create table StarSystems (\n            [systemId] integer primary key,\n            [blobId] integer,            [regionId] integer,            [name] varchar(25),\n            [starType] integer,\n            [systemTime] float(3, 5) not null,\n            [discovered] float(3, 1),\n            [knownMemberCount] smallinteger,\n            [x] smallinteger not null,\n            [y] smallinteger not null,\n            foreign key (blobId) references Blob(blobId)\n            foreign key (regionId) references GalaxyRegions(regionId)\n    );";
    private static String loadByRegionSQL = "select systemId, blobId, regionId, name, starType, systemTime, discovered, knownMemberCount from StarSystems where regionId = ?;";
    private static String loadSQL = "select systemId, blobId, regionId, name, starType, systemTime, discovered, knownMemberCount, x, y from StarSystems where systemId = ?;";
    private static String loadByLocationSQL = "select systemId, blobId, regionId, name, starType, systemTime, discovered, knownMemberCount from StarSystems where x = ? and y = ?;";
    private static String updateSQL = "update StarSystems set name = ?, starType = ?,systemTime = ?,discovered = ?,knownMemberCount = ?where systemId == ?;";
    private static String updateRegionSQL = "update StarSystems set regionId = ? where systemId == ?;";
    private static String updateBlobSQL = "update StarSystems blobId = ?, where systemId == ?;";
    private static String insertSQL = "insert into StarSystems (systemId, regionId, name, starType, systemTime, discovered, knownMemberCount, x, y) values(?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static String insertSQLNoRegion = "insert into StarSystems (systemId, name, starType, systemTime, discovered, knownMemberCount, x, y) values(?, ?, ?, ?, ?, ?, ?, ?);";
    private static String removeSQL = "delete from StarSystems where systemId == ?;";
    private static String existsSQL = "select true from StarSystems where systemId = ?;";
    private GameDatabase gameDatabase;

    public StarSystemHeaderDAO(GameDatabase gameDatabase) {
        this.gameDatabase = gameDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(int id) throws SQLException {
        boolean exists = false;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(existsSQL);
            preparedStatement.setInt(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            exists = resultSet.getBoolean(1);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StarSystemHeader get(int id) throws SQLException {
        this.logger.finest("Loading Star System of ID " + id);
        StarSystemHeader starSystemHeader = null;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(loadSQL);
            preparedStatement.setInt(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.isBeforeFirst()) {
                starSystemHeader = new StarSystemHeader();
                starSystemHeader.id = resultSet.getInt(1);
                starSystemHeader.blobId = resultSet.getInt(2);
                starSystemHeader.regionId = resultSet.getInt(3);
                starSystemHeader.name = resultSet.getString(4);
                starSystemHeader.starType = PlanetType.values()[resultSet.getInt(5)];
                starSystemHeader.systemTime = resultSet.getFloat(6);
                starSystemHeader.discovered = resultSet.getFloat(7);
                starSystemHeader.knownMemberCount = resultSet.getInt(8);
                starSystemHeader.x = resultSet.getShort(9);
                starSystemHeader.y = resultSet.getShort(10);
            }
        }
        return starSystemHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StarSystemHeader> getByRegionId(int regionId) throws SQLException {
        this.logger.finest("Loading Star Systems that belong to regionId " + regionId);
        ArrayList<StarSystemHeader> systems = new ArrayList<StarSystemHeader>();
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(loadByRegionSQL);
            preparedStatement.setShort(1, (short)regionId);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                StarSystemHeader starSystemHeader = new StarSystemHeader();
                starSystemHeader.id = resultSet.getInt(1);
                starSystemHeader.blobId = resultSet.getInt(2);
                starSystemHeader.regionId = resultSet.getInt(3);
                starSystemHeader.name = resultSet.getString(4);
                starSystemHeader.starType = PlanetType.values()[resultSet.getInt(5)];
                starSystemHeader.systemTime = resultSet.getFloat(6);
                starSystemHeader.discovered = resultSet.getFloat(7);
                starSystemHeader.knownMemberCount = resultSet.getInt(8);
                systems.add(starSystemHeader);
            }
        }
        return systems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StarSystemHeader getByLocation(int x, int y) throws SQLException {
        this.logger.finest("Loading Star System at pos " + x + " / " + y);
        StarSystemHeader starSystemHeader = null;
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(loadByLocationSQL);
            preparedStatement.setShort(1, (short)x);
            preparedStatement.setShort(2, (short)y);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.isBeforeFirst()) {
                starSystemHeader = new StarSystemHeader();
                starSystemHeader.id = resultSet.getInt(1);
                starSystemHeader.blobId = resultSet.getInt(2);
                starSystemHeader.regionId = resultSet.getInt(3);
                starSystemHeader.name = resultSet.getString(4);
                starSystemHeader.starType = PlanetType.values()[resultSet.getInt(5)];
                starSystemHeader.systemTime = resultSet.getFloat(6);
                starSystemHeader.discovered = resultSet.getFloat(7);
                starSystemHeader.knownMemberCount = resultSet.getInt(8);
            }
        }
        return starSystemHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int id) throws SQLException {
        this.logger.finest("Removing Star System of ID " + id);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(removeSQL);
            preparedStatement.setInt(1, id);
            preparedStatement.execute();
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(StarSystemHeader starSystemHeader) throws SQLException {
        this.logger.finest("Inserting new Star System with id " + starSystemHeader.id);
        try (Statement preparedStatement = null;){
            if (starSystemHeader.regionId == null) {
                preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertSQLNoRegion);
                preparedStatement.setInt(1, starSystemHeader.id);
                preparedStatement.setString(2, starSystemHeader.name);
                preparedStatement.setInt(3, starSystemHeader.starType.ordinal());
                preparedStatement.setFloat(4, starSystemHeader.systemTime);
                preparedStatement.setFloat(5, starSystemHeader.discovered);
                preparedStatement.setInt(6, starSystemHeader.knownMemberCount);
                preparedStatement.setInt(7, starSystemHeader.x.shortValue());
                preparedStatement.setInt(8, starSystemHeader.y.shortValue());
                preparedStatement.execute();
            } else {
                preparedStatement = this.gameDatabase.getConnection().prepareStatement(insertSQL);
                preparedStatement.setInt(1, starSystemHeader.id);
                preparedStatement.setInt(2, starSystemHeader.regionId);
                preparedStatement.setString(3, starSystemHeader.name);
                preparedStatement.setInt(4, starSystemHeader.starType.ordinal());
                preparedStatement.setFloat(5, starSystemHeader.systemTime);
                preparedStatement.setFloat(6, starSystemHeader.discovered);
                preparedStatement.setInt(7, starSystemHeader.knownMemberCount);
                preparedStatement.setShort(8, starSystemHeader.x);
                preparedStatement.setShort(9, starSystemHeader.y);
                preparedStatement.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(StarSystemHeader starSystemHeader) throws SQLException {
        this.logger.finest("Updating Star System of ID " + starSystemHeader.id);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateSQL);
            preparedStatement.setString(1, starSystemHeader.name);
            preparedStatement.setInt(2, starSystemHeader.starType.ordinal());
            preparedStatement.setFloat(3, starSystemHeader.systemTime);
            preparedStatement.setFloat(4, starSystemHeader.discovered);
            preparedStatement.setInt(5, starSystemHeader.knownMemberCount);
            preparedStatement.setInt(6, starSystemHeader.id);
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, system was not updated!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSystemWithRegionID(int systemId, int regionId) throws SQLException {
        this.logger.finest("Updating Region for Star System of ID " + systemId);
        try (Statement preparedStatement = null;){
            preparedStatement = this.gameDatabase.getConnection().prepareStatement(updateRegionSQL);
            preparedStatement.setInt(1, regionId);
            preparedStatement.setInt(2, systemId);
            int affectedRows = preparedStatement.executeUpdate();
            if (affectedRows == 0) {
                this.logger.warning("No rows affected, system was not updated!");
            }
        }
    }
}

