/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.lang;

import com.badlogic.gdx.files.FileHandle;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.FileHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class I18n {
    public static final Locale[] supportedLanguages = new Locale[]{Locale.ENGLISH, Locale.GERMAN};
    private Logger logger = Logger.getLogger(I18n.class.getCanonicalName());
    private Locale currentLocale;
    private Map<Locale, PropertyResourceBundle> resourceBundles = new HashMap<Locale, PropertyResourceBundle>();
    private ResourceBundle baseBundle;

    public I18n(Locale locale) {
        this.currentLocale = locale;
    }

    public String translate(String key) throws MissingResourceException {
        String translated = null;
        translated = this.resourceBundles.get(this.currentLocale).containsKey(key) ? this.resourceBundles.get(this.currentLocale).getString(key) : this.baseBundle.getString(key);
        return translated;
    }

    public String translate(String key, Object ... params) throws MissingResourceException {
        return String.format(this.translate(key), params);
    }

    public void loadBundles(String path, FileHandler.FileLocation location, String basename) {
        this.baseBundle = this.loadBundle(path + "/" + basename + ".properties", location);
        for (Locale locale : supportedLanguages) {
            PropertyResourceBundle bundle = this.loadBundle(path + "/" + basename + "_" + locale.getLanguage() + ".properties", location);
            if (bundle == null) continue;
            this.resourceBundles.put(locale, bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyResourceBundle loadBundle(String path, FileHandler.FileLocation location) {
        PropertyResourceBundle bundle = null;
        FileHandle fileHandle = AstraXFiles.toGdxFileHandle(path, location);
        InputStream inputStream = null;
        try {
            this.logger.log(Level.INFO, "Loading resource bundle: {0} ", new Object[]{path});
            inputStream = fileHandle.read();
            bundle = new PropertyResourceBundle(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bundle;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public ResourceBundle getBaseBundle() {
        return this.baseBundle;
    }
}

