/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.sfx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.sfx.PlayList;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import java.util.Objects;

public class MusicPlayer {
    private final int STATE_FADEIN = 0;
    private final int STATE_NORMAL = 1;
    private final int STATE_FADEOUT = 2;
    private final int STATE_FINISHED = 3;
    public final int MODE_LINEAR = 0;
    public final int MODE_SHUFFLE = 1;
    private NumberGenerator generator = new NumberGenerator(this.hashCode());
    private int mode = 1;
    private int state = 0;
    private PlayList playList = new PlayList();
    private String nextSong = null;
    private float maxVolume = 1.0f;
    private Song currentSong;

    public MusicPlayer() {
        this.playList.addSong("song1", "Lost in Time", "b5cully", "mods/astrax-core/mus/b5cully - lost in time.ogg");
        this.playList.addSong("song2", "Stellar Nursery", "b5cully", "mods/astrax-core/mus/b5cully - stellar nursery.ogg");
        this.playList.addSong("song3", "Far Away", "b5cully", "mods/astrax-core/mus/b5cully - far away.ogg");
        this.playList.addSong("song4", "Veiled in Stardust", "b5cully", "mods/astrax-core/mus/b5cully - veiled in stardust.ogg");
        this.playList.addSong("song5", "Fabric of Love", "b5cully", "mods/astrax-core/mus/b5cully - fabric of love.ogg");
        this.playList.addSong("song6", "Broken Echoes", "b5cully", "mods/astrax-core/mus/b5cully - broken echoes.ogg");
        this.playList.addSong("main", "Overflowing Void", "b5cully", "mods/astrax-core/mus/b5cully - overflowing void.ogg");
    }

    public void setPlayList(PlayList playList) {
        this.playList = playList;
        this.stopCurrentSong();
    }

    public void pause() {
        this.currentSong.music.pause();
    }

    public void play() {
        if (this.currentSong == null) {
            String nextSongKey = this.getNextSongKey();
            this.currentSong = new Song(0.0f, nextSongKey, this.getSongFile(nextSongKey));
            this.state = 0;
        } else {
            this.playNextSong();
        }
    }

    public void playNextSong() {
        this.stopCurrentSong();
        this.nextSong = this.getNextSongKey();
    }

    private String getNextSongKey() {
        switch (this.mode) {
            case 0: {
                Object[] keys = this.playList.getKeySet();
                if (this.currentSong == null) {
                    return (String)keys[0];
                }
                int i2 = 0;
                String nextSongId = null;
                for (Object value : keys) {
                    if (Objects.equals(value, this.currentSong.songKey)) {
                        boolean playlistEndReached = i2 + 1 >= keys.length;
                        nextSongId = playlistEndReached ? (String)keys[0] : (String)keys[i2 + 1];
                    }
                    ++i2;
                }
                return nextSongId;
            }
            case 1: {
                Object[] keys = this.playList.getKeySet();
                return (String)this.generator.getRandomEntry(keys);
            }
        }
        return null;
    }

    private String getSongFile(String songKey) {
        PlayList.SongInfo songInfo = this.playList.getSongInfoByKey(songKey);
        if (songInfo != null) {
            return songInfo.file;
        }
        return null;
    }

    public void playNextSong(String id) {
        this.stopCurrentSong();
        this.nextSong = id;
    }

    public int getState() {
        return this.state;
    }

    public int getPlayMode() {
        return this.mode;
    }

    public void setPlayMode(int mode) {
        this.mode = mode;
    }

    public float getCurrentVolume() {
        return this.currentSong.volume;
    }

    public float getMaxVolume() {
        return this.maxVolume;
    }

    public void setMaxVolume(float maxVolume) {
        if (maxVolume < 0.0f) {
            return;
        }
        this.maxVolume = maxVolume;
        if (this.currentSong != null) {
            this.currentSong.volume = MathUtils.clamp(this.currentSong.volume, 0.0f, this.maxVolume);
        }
    }

    public void stopCurrentSong() {
        this.state = 2;
    }

    private void playSong(String id) {
        float oldVolume = this.currentSong.volume;
        String songFile = this.getSongFile(id);
        this.currentSong.music.dispose();
        this.currentSong = new Song(oldVolume, id, songFile);
        this.state = 0;
    }

    private void fadeInSong(float delta) {
        this.currentSong.volume = this.currentSong.volume + delta * 0.4f;
        if (this.currentSong.volume > this.maxVolume) {
            this.currentSong.volume = this.maxVolume;
            this.state = 1;
        }
    }

    private void fadeOutSong(float delta) {
        this.currentSong.volume = this.currentSong.volume - delta * 0.4f;
        if (this.currentSong.volume < 0.0f) {
            this.currentSong.volume = 0.0f;
            this.state = 3;
            this.currentSong.music.stop();
        }
    }

    public void update(float delta) {
        if (this.currentSong == null) {
            return;
        }
        this.currentSong.update();
        switch (this.state) {
            case 0: {
                this.fadeInSong(delta);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.fadeOutSong(delta);
                break;
            }
            case 3: {
                this.currentSong.volume = 0.0f;
                if (this.nextSong == null) break;
                this.playSong(this.nextSong);
                this.nextSong = null;
            }
        }
    }

    public void dispose() {
        if (this.currentSong != null) {
            this.currentSong.music.dispose();
        }
    }

    private class Song {
        private Music music;
        private float volume = 0.0f;
        private String songKey = "";
        private String songFile = "";

        public Song(float volume, String songKey, String songFile) {
            this.volume = volume;
            this.songKey = songKey;
            this.songFile = songFile;
            this.music = Gdx.audio.newMusic(Gdx.files.internal(songFile));
            this.music.setVolume(this.volume);
            this.music.setLooping(true);
            this.music.play();
        }

        public void update() {
            if (this.music.isPlaying() || this.music.isLooping()) {
                this.music.setVolume(this.volume);
            }
        }
    }
}

