/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.sfx;

import com.badlogic.gdx.audio.Sound;

public class SoundInstance {
    protected long id;
    protected Sound sound;
    protected boolean isPlaying;
    protected boolean isLooped;

    public SoundInstance(long id, Sound sound) {
        this.id = id;
        this.sound = sound;
    }

    public void loop(float volume) {
        if (this.isPlaying) {
            return;
        }
        this.isPlaying = true;
        this.isLooped = true;
        this.id = this.sound.loop(volume);
    }

    public void resume() {
        if (this.isLooped && !this.isPlaying) {
            this.sound.resume(this.id);
            this.isPlaying = true;
        }
    }

    public void pause() {
        if (this.isLooped) {
            this.sound.pause(this.id);
            this.isPlaying = false;
        }
    }

    public void play(float volume) {
        this.id = this.sound.play(volume);
    }

    public void stop() {
        if (this.isPlaying) {
            this.sound.stop(this.id);
            this.id = -1L;
            this.isPlaying = false;
        }
    }
}

