/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.sfx;

import com.badlogic.gdx.Gdx;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.DataPackSettings;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.sfx.SoundManager;
import com.neutronio.astrax.sfx.SoundSettings;
import com.neutronio.astrax.ui.AstraXSkin;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SoundLoader {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private AstraXApp game;

    public SoundLoader(AstraXApp game) {
        this.game = game;
    }

    public void loadSoundsIntoSoundManagers(DataPackSettings settings) {
        this.logger.log(Level.INFO, "Loading Sounds for datapack...");
        SoundSettings soundSettings = settings.soundSettings;
        this.loadSoundsForDataPack((SoundManager)this.game.getSfxSoundManager(), "mods/" + settings.name + "/", settings.soundSettings.getSoundsToLoad("sfx"));
        this.loadSoundsForDataPack(this.game.getUiSoundManager(), "mods/" + settings.name + "/", settings.soundSettings.getSoundsToLoad("ui"));
    }

    public void removeSoundsFromManagers(DataPackSettings settings) {
        SoundSettings soundSettings = settings.soundSettings;
        this.game.getSfxSoundManager().unloadSounds(soundSettings.getSoundsToLoad("sfx"));
        this.game.getSfxSoundManager().unloadSounds(soundSettings.getSoundsToLoad("ui"));
    }

    public void loadIntoSoundManager(SoundManager manager, AstraXSkin skin) {
        this.loadSoundsForDataPack(manager, skin.getBaseDirectory(), skin.getSoundSettings().getSoundsToLoad("ui"));
    }

    public void loadSoundsForDataPack(SoundManager manager, FileHandler.FileLocation fileLocation, List<SoundSettings.SoundToLoad> soundsToLoad) {
        if (soundsToLoad == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Sounds empty!");
        }
        for (SoundSettings.SoundToLoad sound : soundsToLoad) {
            this.logger.log(Level.INFO, sound.getIdentifier() + " @ " + sound.getPath());
            switch (fileLocation) {
                case ABSOLUTE: {
                    manager.addSound(sound.getIdentifier(), Gdx.audio.newSound(Gdx.files.absolute(sound.getPath())));
                    break;
                }
                case INTERNAL: {
                    manager.addSound(sound.getIdentifier(), Gdx.audio.newSound(Gdx.files.internal(sound.getPath())));
                    break;
                }
                case LOCAL: {
                    manager.addSound(sound.getIdentifier(), Gdx.audio.newSound(Gdx.files.local(sound.getPath())));
                    break;
                }
                case CLASSPATH: {
                    manager.addSound(sound.getIdentifier(), Gdx.audio.newSound(Gdx.files.classpath(sound.getPath())));
                    break;
                }
                case EXTERNAL: {
                    manager.addSound(sound.getIdentifier(), Gdx.audio.newSound(Gdx.files.external(sound.getPath())));
                }
            }
        }
    }

    public void loadSoundsForDataPack(SoundManager manager, String modRoot, List<SoundSettings.SoundToLoad> soundsToLoad) {
        if (soundsToLoad == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Sounds empty!");
        }
        for (SoundSettings.SoundToLoad sound : soundsToLoad) {
            this.logger.log(Level.INFO, sound.getIdentifier() + " @ " + sound.getPath());
            manager.addSound(sound.getIdentifier(), Gdx.audio.newSound(Gdx.files.local(modRoot + sound.getPath())));
        }
    }
}

