/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.sfx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.sfx.ShuffleSound;
import com.neutronio.astrax.sfx.SoundInstance;
import com.neutronio.astrax.sfx.SoundSettings;
import com.neutronio.astrax.util.UsageChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SoundManager {
    protected Logger logger;
    protected UsageChecker usageChecker = new UsageChecker();
    protected Map<String, Sound> sounds = new HashMap<String, Sound>();
    protected List<SoundInstance> soundInstances = new ArrayList<SoundInstance>();
    protected float maxVolume = 1.0f;
    protected String name;

    public SoundManager(String name) {
        this.name = name;
        this.logger = Logger.getLogger("SoundManager[" + name + "]");
    }

    public float getMaxVolume() {
        return this.maxVolume;
    }

    public boolean hasSound(String soundID) {
        return this.sounds.containsKey(soundID);
    }

    public void addSound(String soundID, Sound sound) {
        if (soundID != null && sound != null) {
            this.usageChecker.addId(soundID);
            this.sounds.put(soundID, sound);
        } else {
            Gdx.app.debug(this.getClass().getCanonicalName(), "Could not add sound!");
        }
    }

    public void setMaxVolume(float maxVolume) {
        this.maxVolume = maxVolume;
    }

    public void playSound(ShuffleSound shuffleSound) {
        this.playSoundOnce(shuffleSound.getSoundID() + MathUtils.random(1, shuffleSound.getSoundCount()));
    }

    public void playSoundOnce(String id) {
        this.playSoundOnce(id, 1.0f);
    }

    public void playSoundOnce(String id, float mult) {
        Sound sound = this.sounds.get(id);
        if (sound != null) {
            long playedID = sound.play();
            sound.setVolume(playedID, this.maxVolume * mult);
            this.usageChecker.record(id);
            this.logger.finest("Playing sound " + id);
        } else {
            this.logger.warning("Could not find sound of ID " + id);
        }
    }

    public long playSoundAsLoop(String id) {
        Sound sound = this.sounds.get(id);
        if (sound != null) {
            long loopingSound = sound.loop(this.maxVolume);
            this.usageChecker.record(id);
            this.soundInstances.add(new SoundInstance(loopingSound, sound));
            return loopingSound;
        }
        return 0L;
    }

    public void stopSoundLoop(long soundId) {
        SoundInstance looped = null;
        for (SoundInstance sound : this.soundInstances) {
            if (sound.id != soundId) continue;
            sound.sound.stop(soundId);
            looped = sound;
        }
        if (looped != null) {
            this.soundInstances.remove(looped);
        }
    }

    public void modifyLoopingSound(long soundId, float volume) {
        for (SoundInstance sound : this.soundInstances) {
            if (sound.id != soundId) continue;
            sound.sound.setVolume(soundId, MathUtils.clamp(volume, 0.0f, this.maxVolume));
            break;
        }
    }

    public void modifyLoopingSound(long soundId, float volume, float pitch) {
        for (SoundInstance sound : this.soundInstances) {
            if (sound.id != soundId) continue;
            sound.sound.setVolume(soundId, MathUtils.clamp(volume, 0.0f, this.maxVolume));
            sound.sound.setPitch(soundId, MathUtils.clamp(pitch, 0.0f, 2.0f));
            break;
        }
    }

    public void updateVolume() {
        for (SoundInstance sounds : this.soundInstances) {
            sounds.sound.setVolume(sounds.id, this.maxVolume);
        }
    }

    public void unloadSounds(List<SoundSettings.SoundToLoad> sounds) {
        if (sounds == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Sounds empty!");
        }
        for (SoundSettings.SoundToLoad sound : sounds) {
            Sound soundObject = this.sounds.get(sound.identifier);
            soundObject.stop();
            soundObject.dispose();
            this.sounds.put(sound.identifier, null);
        }
    }

    public String toString() {
        return "SoundManager{maxVolume=" + this.maxVolume + ", name='" + this.name + '\'' + '}';
    }
}

