/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.sfx;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.neutronio.astrax.sfx.SoundInstance;
import com.neutronio.astrax.sfx.SoundManager;
import java.util.ArrayList;
import java.util.List;

public class SpatialSoundManager
extends SoundManager {
    private float maxDistance = 5000.0f;
    private OrthographicCamera camera;
    private List<LoopedSpatialSound> spatialSounds = new ArrayList<LoopedSpatialSound>();

    public SpatialSoundManager(String name) {
        super(name);
    }

    public void setCamera(OrthographicCamera camera) {
        this.camera = camera;
    }

    public LoopedSpatialSound createSpatialSound(String soundId) {
        if (this.camera == null) {
            return null;
        }
        LoopedSpatialSound spatialSound = new LoopedSpatialSound();
        spatialSound.init(soundId);
        this.spatialSounds.add(spatialSound);
        return spatialSound;
    }

    public void resumeSpatialSounds() {
        for (LoopedSpatialSound sound : this.spatialSounds) {
            sound.resume();
        }
    }

    public void pauseSpatialSounds() {
        for (LoopedSpatialSound sound : this.spatialSounds) {
            sound.pause();
        }
    }

    public void removeSpatialSound(LoopedSpatialSound spatialSound) {
        this.sounds.remove(spatialSound);
    }

    public class LoopedSpatialSound {
        protected SoundInstance soundInstance;
        protected float distance;
        protected float panning = 0.0f;
        protected float volume = 0.5f;
        protected float volumeMultiplier = 1.0f;
        protected float pitch = 1.0f;

        public void init(String id) {
            if (this.soundInstance != null) {
                return;
            }
            Sound sound = (Sound)SpatialSoundManager.this.sounds.get(id);
            if (sound != null) {
                this.soundInstance = new SoundInstance(-1L, sound);
                SpatialSoundManager.this.usageChecker.record(id);
            } else {
                SpatialSoundManager.this.logger.severe("Sound of ID '" + id + "' not found!");
            }
        }

        public void loop() {
            if (this.soundInstance == null) {
                return;
            }
            this.soundInstance.loop(this.volume * this.volumeMultiplier);
        }

        public void play() {
            if (this.soundInstance == null) {
                return;
            }
            this.soundInstance.play(this.volume * this.volumeMultiplier);
        }

        public void pause() {
            if (this.soundInstance == null) {
                return;
            }
            this.soundInstance.pause();
        }

        public void resume() {
            if (this.soundInstance == null) {
                return;
            }
            this.soundInstance.resume();
        }

        public void stop() {
            if (this.soundInstance == null) {
                return;
            }
            this.soundInstance.stop();
        }

        public void setPitch(float pitch) {
            this.pitch = MathUtils.clamp(pitch, 0.5f, 2.0f);
        }

        public void setVolumeMultiplier(float volumeMultiplier) {
            this.volumeMultiplier = MathUtils.clamp(volumeMultiplier, 0.0f, SpatialSoundManager.this.maxVolume);
        }

        public float getPanning() {
            return this.panning;
        }

        public float getVolume() {
            return this.volume;
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getDistance() {
            return this.distance;
        }

        public void update(float delta, float globalX, float globalY) {
            this.distance = Vector2.dst(((SpatialSoundManager)SpatialSoundManager.this).camera.position.x, ((SpatialSoundManager)SpatialSoundManager.this).camera.position.y, globalX, globalY);
            this.panning = -1.0f * MathUtils.clamp((((SpatialSoundManager)SpatialSoundManager.this).camera.position.x - globalX) / ((SpatialSoundManager)SpatialSoundManager.this).camera.viewportWidth, -1.0f, 1.0f);
            this.volume = MathUtils.clamp(1.0f - this.distance / SpatialSoundManager.this.maxDistance, 0.0f, 1.0f);
            this.soundInstance.sound.setPan(this.soundInstance.id, this.panning, MathUtils.clamp(this.volume * this.volumeMultiplier, 0.0f, SpatialSoundManager.this.maxVolume));
            this.soundInstance.sound.setPitch(this.soundInstance.id, this.pitch);
        }
    }
}

