/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.Touchpad;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.SpriteDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.SkinSettings;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.sfx.ButtonSounds;
import com.neutronio.astrax.sfx.SoundSettings;
import com.neutronio.astrax.ui.commons.buttons.ReactiveColor;
import com.neutronio.astrax.ui.commons.buttons.ReactiveDrawable;
import com.neutronio.astrax.util.AstraXUtil;
import com.neutronio.astrax.util.UsageChecker;
import java.io.IOException;
import java.util.Map;

public class AstraXSkin
extends Skin {
    private String baseDirectory;
    private UsageChecker usageChecker = new UsageChecker();
    private SoundSettings soundSettings;
    private static final Class[] defaultTagClasses = new Class[]{BitmapFont.class, Color.class, Skin.TintedDrawable.class, NinePatchDrawable.class, SpriteDrawable.class, TextureRegionDrawable.class, TiledDrawable.class, Button.ButtonStyle.class, CheckBox.CheckBoxStyle.class, ImageButton.ImageButtonStyle.class, ImageTextButton.ImageTextButtonStyle.class, Label.LabelStyle.class, List.ListStyle.class, ProgressBar.ProgressBarStyle.class, ScrollPane.ScrollPaneStyle.class, SelectBox.SelectBoxStyle.class, Slider.SliderStyle.class, SplitPane.SplitPaneStyle.class, TextButton.TextButtonStyle.class, TextField.TextFieldStyle.class, TextTooltip.TextTooltipStyle.class, Touchpad.TouchpadStyle.class, Tree.TreeStyle.class, Window.WindowStyle.class, ButtonSounds.class};
    private final ObjectMap<String, Class> jsonClassTags = new ObjectMap(defaultTagClasses.length);

    public AstraXSkin(String baseDirectory, TextureAtlas atlas) {
        super(atlas);
        for (Class c : defaultTagClasses) {
            this.jsonClassTags.put(c.getSimpleName(), c);
        }
        this.baseDirectory = baseDirectory;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setSoundSettings(SoundSettings soundSettings) {
        this.soundSettings = soundSettings;
    }

    public SoundSettings getSoundSettings() {
        return this.soundSettings;
    }

    public void load(String path, FileHandler.FileLocation fileLocation, SkinSettings skinSettings) {
        FileHandle fileHandle = AstraXFiles.toGdxFileHandle(path, fileLocation);
        try {
            if (skinSettings.uiColors.isEmpty()) {
                skinSettings.uiColors = SkinSettings.getDefaultColors();
            }
            StringBuilder builder = AstraXApp.astraX.getAstraXFiles().readFileContents(path, fileLocation);
            for (Map.Entry<String, Color> colorEntry : skinSettings.uiColors.entrySet()) {
                int startIndex = builder.indexOf("$" + colorEntry.getKey());
                if (startIndex < 0) continue;
                String hex = AstraXUtil.colorToHexRGBAString(colorEntry.getValue().cpy().mul(1.2f));
                builder.replace(startIndex, startIndex + hex.length(), hex);
            }
            Json jsonLoader = this.getJsonLoader(fileHandle);
            jsonLoader.readValue(Skin.class, null, new JsonReader().parse(builder.toString()));
        }
        catch (SerializationException ex) {
            throw new SerializationException("Error reading file: " + fileHandle, ex);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load(FileHandle skinFile) {
        throw new UnsupportedOperationException("Do not use this method");
    }

    @Override
    public <T> T get(String name, Class<T> type) {
        this.usageChecker.record(type.getSimpleName() + ":" + name);
        return super.get(name, type);
    }

    @Override
    protected Json getJsonLoader(final FileHandle skinFile) {
        final AstraXSkin skin = this;
        Json json = new Json(){
            private static final String parentFieldName = "parent";

            @Override
            public <T> T readValue(Class<T> type, Class elementType, JsonValue jsonData) {
                if (jsonData != null && jsonData.isString() && !ClassReflection.isAssignableFrom(CharSequence.class, type)) {
                    return AstraXSkin.this.get(jsonData.asString(), type);
                }
                return super.readValue(type, elementType, jsonData);
            }

            @Override
            protected boolean ignoreUnknownField(Class type, String fieldName) {
                return fieldName.equals(parentFieldName);
            }

            @Override
            public void readFields(Object object, JsonValue jsonMap) {
                if (jsonMap.has(parentFieldName)) {
                    String parentName = this.readValue(parentFieldName, String.class, jsonMap);
                    Class<?> parentType = object.getClass();
                    while (true) {
                        try {
                            this.copyFields(AstraXSkin.this.get(parentName, parentType), object);
                        }
                        catch (GdxRuntimeException ex) {
                            if ((parentType = parentType.getSuperclass()) != Object.class) continue;
                            SerializationException se = new SerializationException("Unable to find parent resource with name: " + parentName);
                            se.addTrace(jsonMap.child.trace());
                            throw se;
                        }
                        break;
                    }
                }
                super.readFields(object, jsonMap);
            }
        };
        json.setTypeName(null);
        json.setUsePrototypes(false);
        json.setSerializer(Skin.class, new Json.ReadOnlySerializer<Skin>(){

            @Override
            public Skin read(Json json, JsonValue typeToValueMap, Class ignored) {
                JsonValue valueMap = typeToValueMap.child;
                while (valueMap != null) {
                    try {
                        Class type = json.getClass(valueMap.name());
                        if (type == null) {
                            type = ClassReflection.forName(valueMap.name());
                        }
                        this.readNamedObjects(json, type, valueMap);
                    }
                    catch (ReflectionException ex) {
                        throw new SerializationException(ex);
                    }
                    valueMap = valueMap.next;
                }
                return skin;
            }

            private void readNamedObjects(Json json, Class type, JsonValue valueMap) {
                Class addType = type == Skin.TintedDrawable.class ? Drawable.class : type;
                JsonValue valueEntry = valueMap.child;
                while (valueEntry != null) {
                    Object object = json.readValue(type, valueEntry);
                    if (object != null) {
                        AstraXSkin.this.usageChecker.addId(type.getSimpleName() + ":" + valueEntry.name);
                        try {
                            AstraXSkin.this.add(valueEntry.name, object, addType);
                            if (addType != Drawable.class && ClassReflection.isAssignableFrom(Drawable.class, addType)) {
                                AstraXSkin.this.add(valueEntry.name, object, Drawable.class);
                            }
                        }
                        catch (Exception ex) {
                            throw new SerializationException("Error reading " + ClassReflection.getSimpleName(type) + ": " + valueEntry.name, ex);
                        }
                    }
                    valueEntry = valueEntry.next;
                }
            }
        });
        json.setSerializer(BitmapFont.class, new Json.ReadOnlySerializer<BitmapFont>(){

            @Override
            public BitmapFont read(Json json, JsonValue jsonData, Class type) {
                String path = json.readValue("file", String.class, jsonData);
                int scaledSize = json.readValue("scaledSize", Integer.TYPE, Integer.valueOf(-1), jsonData);
                Boolean flip = json.readValue("flip", Boolean.class, Boolean.valueOf(false), jsonData);
                Boolean markupEnabled = json.readValue("markupEnabled", Boolean.class, Boolean.valueOf(false), jsonData);
                FileHandle fontFile = skinFile.parent().child(path);
                if (!fontFile.exists()) {
                    fontFile = Gdx.files.internal(path);
                }
                if (!fontFile.exists()) {
                    throw new SerializationException("Font file not found: " + fontFile);
                }
                String regionName = fontFile.nameWithoutExtension();
                try {
                    FileHandle imageFile;
                    TextureRegion region;
                    Array<TextureRegion> regions = skin.getRegions(regionName);
                    BitmapFont font = regions != null ? new BitmapFont(new BitmapFont.BitmapFontData(fontFile, flip), regions, true) : ((region = skin.optional(regionName, TextureRegion.class)) != null ? new BitmapFont(fontFile, region, (boolean)flip) : ((imageFile = fontFile.parent().child(regionName + ".png")).exists() ? new BitmapFont(fontFile, imageFile, (boolean)flip) : new BitmapFont(fontFile, flip)));
                    font.getData().markupEnabled = markupEnabled;
                    if (scaledSize != -1) {
                        font.getData().setScale((float)scaledSize / font.getCapHeight());
                    }
                    return font;
                }
                catch (RuntimeException ex) {
                    throw new SerializationException("Error loading bitmap font: " + fontFile, ex);
                }
            }
        });
        json.setSerializer(Color.class, new Json.ReadOnlySerializer<Color>(){

            @Override
            public Color read(Json json, JsonValue jsonData, Class type) {
                if (jsonData.isString()) {
                    return AstraXSkin.this.get(jsonData.asString(), Color.class);
                }
                String hex = json.readValue("hex", String.class, (String)null, jsonData);
                if (hex != null) {
                    return Color.valueOf(hex);
                }
                float r = json.readValue("r", Float.TYPE, Float.valueOf(0.0f), jsonData).floatValue();
                float g = json.readValue("g", Float.TYPE, Float.valueOf(0.0f), jsonData).floatValue();
                float b = json.readValue("b", Float.TYPE, Float.valueOf(0.0f), jsonData).floatValue();
                float a = json.readValue("a", Float.TYPE, Float.valueOf(1.0f), jsonData).floatValue();
                return new Color(r, g, b, a);
            }
        });
        json.setSerializer(Skin.TintedDrawable.class, new Json.ReadOnlySerializer(){

            @Override
            public Object read(Json json, JsonValue jsonData, Class type) {
                String name = json.readValue("name", String.class, jsonData);
                Color color = json.readValue("color", Color.class, jsonData);
                if (color == null) {
                    throw new SerializationException("TintedDrawable missing color: " + jsonData);
                }
                Drawable drawable = AstraXSkin.this.newDrawable(name, color);
                if (drawable instanceof BaseDrawable) {
                    BaseDrawable named = (BaseDrawable)drawable;
                    named.setName(jsonData.name + " (" + name + ", " + color + ")");
                }
                return drawable;
            }
        });
        json.setSerializer(ReactiveDrawable.class, new Json.ReadOnlySerializer(){

            @Override
            public Object read(Json json, JsonValue jsonData, Class type) {
                ReactiveDrawable reactiveDrawable = new ReactiveDrawable();
                reactiveDrawable.baseRegion = AstraXSkin.this.newDrawable(json.readValue("baseRegion", String.class, jsonData));
                reactiveDrawable.upColor = json.readValue("upColor", Color.class, jsonData);
                reactiveDrawable.downColor = json.readValue("downColor", Color.class, jsonData);
                reactiveDrawable.overColor = json.readValue("overColor", Color.class, jsonData);
                reactiveDrawable.checkedColor = json.readValue("checkedColor", Color.class, jsonData);
                reactiveDrawable.checkedOverColor = json.readValue("checkedOverColor", Color.class, jsonData);
                reactiveDrawable.checkedDownColor = json.readValue("checkedDownColor", Color.class, jsonData);
                reactiveDrawable.disabledColor = json.readValue("disabledColor", Color.class, jsonData);
                reactiveDrawable.focusedColor = json.readValue("focusedColor", Color.class, jsonData);
                reactiveDrawable.focusedCheckedColor = json.readValue("focusedCheckedColor", Color.class, jsonData);
                return reactiveDrawable;
            }
        });
        json.setSerializer(ReactiveColor.class, new Json.ReadOnlySerializer(){

            @Override
            public Object read(Json json, JsonValue jsonData, Class type) {
                ReactiveColor reactiveColor = new ReactiveColor();
                reactiveColor.upColor = json.readValue("upColor", Color.class, jsonData);
                reactiveColor.downColor = json.readValue("downColor", Color.class, jsonData);
                reactiveColor.overColor = json.readValue("overColor", Color.class, jsonData);
                reactiveColor.checkedColor = json.readValue("checkedColor", Color.class, jsonData);
                reactiveColor.checkedOverColor = json.readValue("checkedOverColor", Color.class, jsonData);
                reactiveColor.checkedDownColor = json.readValue("checkedDownColor", Color.class, jsonData);
                reactiveColor.disabledColor = json.readValue("disabledColor", Color.class, jsonData);
                reactiveColor.focusedColor = json.readValue("focusedColor", Color.class, jsonData);
                reactiveColor.focusedCheckedColor = json.readValue("focusedCheckedColor", Color.class, jsonData);
                return reactiveColor;
            }
        });
        json.setSerializer(ButtonSounds.class, new Json.ReadOnlySerializer(){

            @Override
            public Object read(Json json, JsonValue jsonData, Class type) {
                ButtonSounds buttonSounds = new ButtonSounds();
                buttonSounds.soundPressed = json.readValue("soundPressed", String.class, (String)null, jsonData);
                buttonSounds.soundRelease = json.readValue("soundRelease", String.class, (String)null, jsonData);
                buttonSounds.soundOver = json.readValue("soundOver", String.class, (String)null, jsonData);
                return buttonSounds;
            }
        });
        for (ObjectMap.Entry entry : this.jsonClassTags) {
            json.addClassTag((String)entry.key, (Class)entry.value);
        }
        return json;
    }

    public UsageChecker getUsageChecker() {
        return this.usageChecker;
    }
}

