/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.AbstractApplicationFactory;
import com.neutronio.astrax.app.ApplicationSettings;
import com.neutronio.astrax.app.RepositoryFactory;
import com.neutronio.astrax.app.SkinSettings;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.NavigationGraphics;
import com.neutronio.astrax.io.json.config.JSONToSoundSettings;
import com.neutronio.astrax.lang.I18n;
import com.neutronio.astrax.sfx.ButtonSounds;
import com.neutronio.astrax.ui.AstraXSkin;
import com.neutronio.astrax.ui.ContainerComponentFactory;
import com.neutronio.astrax.ui.InformationComponentFactory;
import com.neutronio.astrax.ui.InputComponentFactory;
import com.neutronio.astrax.ui.NavigationalComponentFactory;
import com.neutronio.astrax.ui.commons.ButtonClickListener;
import com.neutronio.astrax.ui.commons.CheckBoxSounds;
import com.neutronio.astrax.ui.commons.ScrollContentSettings;
import com.neutronio.astrax.ui.commons.ScrollPaneGroup;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.tab.MenuPanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.Header;
import com.neutronio.astrax.ui.commons.widgets.TextButtonTabs;
import com.neutronio.astrax.ui.game.menu.HelpTab;
import com.neutronio.astrax.ui.game.menu.SettingsTab;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ComponentFactory
extends AbstractApplicationFactory {
    public static int GAME_MENU_WIDTH;
    public static int GAME_MENU_HEIGHT;
    public static int PRIMARY_TAB_WIDTH;
    public static int PRIMARY_TAB_HEIGHT;
    public static int SECONDARY_TAB_WIDTH;
    public static int SECONDARY_TAB_HEIGHT;
    private AstraXSkin skin;
    @Deprecated
    private Map<String, ButtonSounds> buttonSounds = new HashMap<String, ButtonSounds>();
    private I18n coreTranslations;
    private Map<String, I18n> translations;
    private float defaultTabWidth = 1200.0f;
    private float defaultTabHeight = 600.0f;
    @Deprecated
    private InputComponentFactory inputComponentFactory;
    @Deprecated
    private NavigationalComponentFactory navigationalComponentFactory;
    @Deprecated
    private InformationComponentFactory informationComponentFactory;
    @Deprecated
    private ContainerComponentFactory containerComponentFactory;
    private AstraXRenderContext hudRenderContext;
    private AstraXRenderContext uiRenderContext;

    public ComponentFactory(AstraXApp game) {
        super(game);
        this.addButtonSounds("primary", "button_click1", "button_uncheck1", "button_over1");
        this.addButtonSounds("secondary", "button_click2", "button_uncheck1", "button_over1");
        this.addButtonSounds("tab", "switch:on", "switch:off", "button_over1");
        this.addButtonSounds("default", "button_click1", "button_uncheck1", "button_over1");
        this.addButtonSounds("mainMenu", "button_click2", "button_uncheck1", "button_over1");
        this.addButtonSounds("starMap", "button_click2", "button_uncheck2", "button_over1");
        this.addButtonSounds("checkBox", "switch:on", "switch:off", "button_over1");
        this.addButtonSounds("inventoryDrop", "switch1", "retract", "button_over1");
        this.addButtonSounds("inventoryDropAll", "switch:on", "retract", "button_over1");
        this.addButtonSounds("dropDown", "switch:on", "retract", "retract");
        this.addButtonSounds("dice", "dice1", null, "click:soft");
        this.addButtonSounds("submit", "button_click2", "button_uncheck1", "button_over1");
        this.addButtonSounds("start", "chime", "button_uncheck1", "button_over1");
        this.addButtonSounds("zoom:in", "zoom:in", "button_uncheck2", "button_over1");
        this.addButtonSounds("zoom:out", "zoom:out", "button_uncheck2", "button_over1");
        this.addButtonSounds("zoom:reset", "zoom:reset", "button_uncheck2", "button_over1");
    }

    public void loadSkin(SkinSettings skinSettings) {
        GAME_MENU_WIDTH = Gdx.graphics.getWidth() - 20;
        GAME_MENU_HEIGHT = Gdx.graphics.getHeight() - 100;
        PRIMARY_TAB_WIDTH = MathUtils.clamp(Gdx.graphics.getWidth() - 200, 800, 1200);
        PRIMARY_TAB_HEIGHT = MathUtils.clamp(Gdx.graphics.getHeight() - 200, 600, Gdx.graphics.getHeight() - 200);
        SECONDARY_TAB_WIDTH = (int)((float)PRIMARY_TAB_WIDTH * 0.7f);
        SECONDARY_TAB_HEIGHT = (int)((float)PRIMARY_TAB_HEIGHT * 0.7f);
        this.logger.info("Loading skin into app...");
        FileHandle skinFile = Gdx.files.internal(skinSettings.baseDirectory + skinSettings.stylesAtlasFile);
        this.skin = new AstraXSkin(skinSettings.baseDirectory, new TextureAtlas(skinFile));
        this.skin.load(skinSettings.baseDirectory + skinSettings.stylesJsonFile, skinSettings.skinLocation, skinSettings);
        try {
            this.logger.info("Loading sounds for skin...");
            StringBuilder fileContents = AstraXApp.astraX.getAstraXFiles().readFileContents(skinSettings.baseDirectory + skinSettings.soundsFile, skinSettings.skinLocation);
            JSONObject json = new JSONObject(fileContents.toString());
            RepositoryFactory repositoryFactory = AstraXApp.astraX.getRepositoryFactory();
            JSONToSoundSettings soundSettingsConverter = repositoryFactory.getDataManager().getConverter(JSONToSoundSettings.class);
            this.skin.setSoundSettings(soundSettingsConverter.convert(json.toMap()));
            AstraXApp.astraX.getSoundLoader().loadIntoSoundManager(AstraXApp.astraX.getUiSoundManager(), this.skin);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadTranslations(SkinSettings skinSettings) {
        this.coreTranslations = new I18n(skinSettings.language);
        this.coreTranslations.loadBundles(skinSettings.translationsPath, skinSettings.skinLocation, skinSettings.translationsBundleName);
    }

    public void setHudRenderContext(AstraXRenderContext hudRenderContext) {
        this.hudRenderContext = hudRenderContext;
    }

    public AstraXRenderContext getHudRenderContext() {
        return this.hudRenderContext;
    }

    public AstraXRenderContext getUiRenderContext() {
        return this.uiRenderContext;
    }

    public void setUiRenderContext(AstraXRenderContext uiRenderContext) {
        this.uiRenderContext = uiRenderContext;
    }

    public ImageTextButton.ImageTextButtonStyle copy(ImageTextButton.ImageTextButtonStyle buttonStyle) {
        ImageTextButton.ImageTextButtonStyle buttonStyleCopy = new ImageTextButton.ImageTextButtonStyle();
        buttonStyleCopy.imageUp = buttonStyle.imageUp;
        buttonStyleCopy.imageDown = buttonStyle.imageDown;
        buttonStyleCopy.imageOver = buttonStyle.imageOver;
        buttonStyleCopy.imageChecked = buttonStyle.imageChecked;
        buttonStyleCopy.imageCheckedDown = buttonStyle.imageCheckedDown;
        buttonStyleCopy.imageCheckedOver = buttonStyle.imageCheckedOver;
        buttonStyleCopy.imageDisabled = buttonStyle.imageDisabled;
        buttonStyleCopy.font = buttonStyle.font;
        buttonStyleCopy.fontColor = buttonStyle.fontColor;
        buttonStyleCopy.downFontColor = buttonStyle.downFontColor;
        buttonStyleCopy.overFontColor = buttonStyle.overFontColor;
        buttonStyleCopy.disabledFontColor = buttonStyle.disabledFontColor;
        buttonStyleCopy.checkedFontColor = buttonStyle.checkedFontColor;
        buttonStyleCopy.checkedDownFontColor = buttonStyle.checkedDownFontColor;
        buttonStyleCopy.checkedOverFontColor = buttonStyle.checkedOverFontColor;
        buttonStyleCopy.checkedFocusedFontColor = buttonStyle.checkedFocusedFontColor;
        buttonStyleCopy.up = buttonStyle.up;
        buttonStyleCopy.down = buttonStyle.down;
        buttonStyleCopy.over = buttonStyle.over;
        buttonStyleCopy.checked = buttonStyle.checked;
        buttonStyleCopy.checkedDown = buttonStyle.checkedDown;
        buttonStyleCopy.focused = buttonStyle.focused;
        return buttonStyleCopy;
    }

    public Tooltip<AstraXLabel> getToolTip(String text) {
        AstraXLabel label = new AstraXLabel(this, text, "default", "border");
        Tooltip<AstraXLabel> tooltip = new Tooltip<AstraXLabel>(label);
        tooltip.setInstant(true);
        return tooltip;
    }

    public TextButton getPrimaryCompactTextButton(String text, String soundID, boolean canCheck) {
        TextButton textButton = new TextButton(text, this.getSkin(), canCheck ? "primary-compact" : "primary-compact-no-checked");
        textButton.getLabelCell().getActor().setTouchable(Touchable.disabled);
        textButton.getLabelCell().pad(10.0f);
        textButton.addListener(this.getButtonSoundListener(soundID == null ? "default" : soundID));
        return textButton;
    }

    public AstraXTextButton getTextButton(String style, String text, String soundID) {
        AstraXTextButton textButton = new AstraXTextButton(this, style);
        textButton.setText(text);
        return textButton;
    }

    public ImageTextButton getImageTextButton(String style, String inlineIcon, String text, String soundID) {
        ImageTextButton.ImageTextButtonStyle buttonStyle = this.copy(this.getSkin().get(style, ImageTextButton.ImageTextButtonStyle.class));
        Drawable inlineIconDrawable = this.getSkin().getDrawable(inlineIcon);
        buttonStyle.imageUp = this.getSkin().getDrawable(inlineIcon);
        buttonStyle.imageDown = inlineIconDrawable;
        buttonStyle.imageOver = inlineIconDrawable;
        buttonStyle.imageChecked = inlineIconDrawable;
        buttonStyle.imageCheckedDown = inlineIconDrawable;
        buttonStyle.imageCheckedOver = inlineIconDrawable;
        buttonStyle.imageDisabled = inlineIconDrawable;
        ImageTextButton button = new ImageTextButton(text, buttonStyle);
        ((Actor)button.getLabelCell().getActor()).setTouchable(Touchable.disabled);
        button.getLabelCell().pad(10.0f);
        button.addListener(this.getButtonSoundListener(soundID == null ? "default" : soundID));
        return button;
    }

    public TextButton getPrimaryTextButton(String text, String soundID) {
        TextButton textButton = new TextButton(text, this.getSkin(), "primary");
        textButton.getLabelCell().getActor().setTouchable(Touchable.disabled);
        textButton.addListener(this.getButtonSoundListener(soundID == null ? "default" : soundID));
        return textButton;
    }

    public Button getCheckBox() {
        Button checkBox = new Button(this.getSkin(), "checkBox_1");
        checkBox.addListener(this.getCheckBoxSoundListener("checkBox"));
        return checkBox;
    }

    @Deprecated
    public ScrollPaneGroup getScrollContentPane(String scrollPaneStyleName, int scrollHeight) {
        ScrollPaneGroup scrollPaneGroup = new ScrollPaneGroup();
        scrollPaneGroup.scrollContent = new Table(this.skin);
        scrollPaneGroup.scrollContent.align(2);
        scrollPaneGroup.scrollPane = new ScrollPane((Actor)scrollPaneGroup.scrollContent, this.skin, scrollPaneStyleName);
        scrollPaneGroup.scrollPane.setFadeScrollBars(false);
        scrollPaneGroup.container = new Table(this.skin);
        scrollPaneGroup.container.add(scrollPaneGroup.scrollPane).height(scrollHeight).top();
        return scrollPaneGroup;
    }

    public String translate(String identifier) {
        return this.coreTranslations.translate(identifier);
    }

    public String translateMarked(String key) {
        if (key.startsWith("$")) {
            return this.coreTranslations.translate(key.substring(1));
        }
        return key;
    }

    public String translate(String identifier, Object ... params) {
        return this.coreTranslations.translate(identifier, params);
    }

    @Deprecated
    public Button getButtonForMarker(NavigationGraphics marker) {
        return new Button(this.skin, "targetType_marker");
    }

    @Deprecated
    public Button getButtonForShip() {
        return new Button(this.skin, "targetType_ship");
    }

    @Deprecated
    public Button getButtonForUnknown() {
        return new Button(this.skin, "targetType_unknown");
    }

    public void playUISound(String soundID) {
        this.gameContainer.getUiSoundManager().playSoundOnce(soundID);
    }

    public void playUISound(String soundID, float mult) {
        this.gameContainer.getUiSoundManager().playSoundOnce(soundID, mult);
    }

    private void addButtonSounds(String identifier, String soundDown, String soundUncheck, String soundHover) {
        this.buttonSounds.put(identifier, new ButtonSounds(soundDown, soundUncheck, soundHover));
    }

    public ButtonSounds getButtonSounds(String identifier) {
        return this.buttonSounds.get(identifier);
    }

    public ButtonClickListener getButtonSoundListener(String buttonSoundIdentifier) {
        ButtonSounds buttonSounds = this.getButtonSounds(buttonSoundIdentifier);
        if (buttonSounds == null) {
            throw new AstraXException(AstraXException.ErrorCode.E3000, "ButtonSound: " + buttonSoundIdentifier);
        }
        return new ButtonClickListener(this.gameContainer.getUiSoundManager(), buttonSounds);
    }

    public ClickListener getCheckBoxSoundListener(String buttonSoundIdentifier) {
        ButtonSounds buttonSounds = this.getButtonSounds(buttonSoundIdentifier);
        if (buttonSounds == null) {
            throw new AstraXException(AstraXException.ErrorCode.E3000, "ButtonSound: " + buttonSoundIdentifier);
        }
        return new CheckBoxSounds(this.gameContainer.getUiSoundManager(), buttonSounds);
    }

    public Skin getSkin() {
        return this.skin;
    }

    public ButtonSounds getMainButtonSounds() {
        return this.getButtonSounds("mainMenu");
    }

    public ButtonSounds getStarmapButtonSounds() {
        return this.getButtonSounds("starMap");
    }

    public Table getGameSettingsTab(String header) {
        Table table = new Table();
        Header headerComponent = this.getHeader(header);
        table.add(headerComponent).expand();
        return table;
    }

    public TextButtonTabs getTextTabs(TextButtonTabs.TextButtonTabModel tabTextModel, TextButtonTabs.ButtonSettings buttonSettings, ScrollContentSettings scrollContentSettings) {
        TextButtonTabs tabText = new TextButtonTabs(this.skin);
        tabText.setContentTabSettings(scrollContentSettings);
        tabText.setButtonSettings(buttonSettings);
        tabText.setButtonClickListener(new ButtonClickListener(this.gameContainer.getUiSoundManager(), new ButtonSounds("click3", "tap2", "tap1")));
        tabText.setTextScrollPane(this.navigationalComponentFactory.getScrollContentPane("default-vertical", scrollContentSettings.minScrollableContentHeight));
        tabText.setTextButtonScrollPane(this.navigationalComponentFactory.getScrollContentPane("default-vertical", scrollContentSettings.minScrollableContentHeight));
        tabText.setTabTextModel(tabTextModel);
        tabText.construct();
        tabText.pack();
        return tabText;
    }

    public MenuPanel<SettingsTab> getSettingsTab(ApplicationSettings applicationSettings) {
        MenuPanel<SettingsTab> menuPanel = new MenuPanel<SettingsTab>();
        SettingsTab settingsTab = new SettingsTab(this);
        settingsTab.applyStarterValues(applicationSettings);
        settingsTab.construct();
        settingsTab.setSize(this.defaultTabWidth, this.defaultTabHeight);
        menuPanel.setHeader(this.getHeader("Settings"));
        menuPanel.setContent(settingsTab);
        return menuPanel;
    }

    public MenuPanel<HelpTab> getHelpTab(TextButtonTabs.TextButtonTabModel model) {
        MenuPanel<HelpTab> helpTabMenuPanel = new MenuPanel<HelpTab>();
        HelpTab helpTab = new HelpTab(this.skin);
        TextButtonTabs.ButtonSettings buttonSettings = new TextButtonTabs.ButtonSettings();
        buttonSettings.styleClass = TextButton.TextButtonStyle.class;
        buttonSettings.styleName = "secondary";
        buttonSettings.minButtonHeight = 60;
        buttonSettings.minButtonWidth = 160;
        ScrollContentSettings scrollContentSettings = new ScrollContentSettings();
        scrollContentSettings.minContainerHeight = 600;
        scrollContentSettings.minScrollableContentWidth = 600;
        scrollContentSettings.minScrollableContentHeight = 400;
        TextButtonTabs textTabs = this.getTextTabs(model, buttonSettings, scrollContentSettings);
        helpTab.setTabs(textTabs);
        helpTab.construct();
        helpTab.pack();
        helpTab.setSize(this.defaultTabWidth, this.defaultTabHeight);
        helpTabMenuPanel.setHeader(this.getHeader("Help"));
        helpTabMenuPanel.setContent(helpTab);
        return helpTabMenuPanel;
    }

    public Header getHeader(String title) {
        Header header = new Header(this);
        header.setTitle(title);
        header.construct();
        return header;
    }

    public Header getHeader(String title, float minWidth) {
        Header header = new Header(this);
        header.setTitle(title);
        header.construct();
        return header;
    }
}

