/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.widgets.IconPicker;

public class IconSelectBox
extends Group {
    private ComponentFactory factory;
    private IconPicker iconPicker;
    private Button selectedIcon;
    private String selectedDrawableName = "";
    private String soundExpand = "expand";
    private String soundRetract = "retract";

    public IconSelectBox(final ComponentFactory factory) {
        this.factory = factory;
        this.iconPicker = new IconPicker(factory);
        this.iconPicker.setIconPickerListener(new IconPicker.IconPickerListener(){

            @Override
            public void onIconClicked(Image icon) {
                ((IconSelectBox)IconSelectBox.this).selectedIcon.getStyle().up = icon.getDrawable();
                ((IconSelectBox)IconSelectBox.this).selectedIcon.getStyle().down = icon.getDrawable();
                IconSelectBox.this.setSelectedDrawableName(icon.getName());
                IconSelectBox.this.iconPicker.addAction(Actions.sequence((Action)Actions.fadeOut(0.5f), (Action)Actions.hide()));
                factory.playUISound(IconSelectBox.this.soundRetract);
            }
        });
        this.iconPicker.setPosition(24.0f, 24.0f);
        this.selectedIcon = new Button(factory.getSkin(), "checkBox_1");
        this.selectedIcon.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                factory.playUISound(IconSelectBox.this.soundExpand);
                IconSelectBox.this.iconPicker.addAction(Actions.sequence((Action)Actions.show(), (Action)Actions.fadeIn(0.2f)));
            }
        });
        this.iconPicker.setVisible(false);
        this.addActor(this.selectedIcon);
        this.addActor(this.iconPicker);
        this.setSize(this.selectedIcon.getMinWidth(), this.selectedIcon.getMinHeight());
    }

    public String getSelectedDrawableName() {
        return this.selectedDrawableName;
    }

    public void setSelectedDrawableName(String selectedDrawableName) {
        this.selectedDrawableName = selectedDrawableName;
        this.iconPicker.setSelectedIcon(selectedDrawableName);
    }

    public IconPicker getIconPicker() {
        return this.iconPicker;
    }
}

