/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.input.DeviceType;
import java.util.logging.Logger;

public class KeyCatcherComponent
extends Group {
    protected static Logger logger = Logger.getLogger(KeyCatcherComponent.class.getCanonicalName());
    public static final int TYPE_KEY = 0;
    public static final int TYPE_MOUSE = 1;
    protected KeyCatcher keyCatcher;
    protected Drawable keyIcon;
    protected Label label;
    protected KeyCatcherListener listener;
    protected String forAction;
    protected int keyCode = -1;
    protected DeviceType deviceType;
    protected KeyMappingSettings.InputType inputType;

    public KeyCatcherComponent(Skin skin) {
        this.label = new Label((CharSequence)"", skin);
        this.label.setSize(80.0f, 24.0f);
        this.keyCatcher = new KeyCatcher(this);
        this.setSize(80.0f, 24.0f);
        this.addActor(this.label);
    }

    public void setKeyName(String device, String keyName) {
        this.label.setText(device + " " + keyName);
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(int keyCode) {
        this.keyCode = keyCode;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType inputType) {
        this.deviceType = inputType;
    }

    public KeyMappingSettings.InputType getInputType() {
        return this.inputType;
    }

    public void setInputType(KeyMappingSettings.InputType inputType) {
        this.inputType = inputType;
    }

    public String getForAction() {
        return this.forAction;
    }

    public void setForAction(String forAction) {
        this.forAction = forAction;
    }

    public KeyCatcherListener getListener() {
        return this.listener;
    }

    public void setListener(KeyCatcherListener listener) {
        this.listener = listener;
    }

    public static class KeyCatcher {
        protected final KeyCatcherComponent parent;
        protected ClickListener mouseCatcher;
        protected InputListener keyBoardCatcher;
        boolean isCatching = false;

        public KeyCatcher(final KeyCatcherComponent parent) {
            this.parent = parent;
            this.mouseCatcher = new ClickListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    if (!KeyCatcher.this.isCatching) {
                        KeyCatcher.this.isCatching = true;
                        parent.getListener().onStartKeyCatching(parent);
                    } else {
                        KeyCatcher.this.isCatching = false;
                        parent.deviceType = DeviceType.MOUSE;
                        parent.keyCode = button;
                        parent.getListener().onEndKeyCatching(parent, parent.deviceType, button);
                    }
                    event.stop();
                    return true;
                }
            };
            this.parent.addListener(this.mouseCatcher);
            this.keyBoardCatcher = new InputListener(){

                @Override
                public boolean keyDown(InputEvent event, int keycode) {
                    if (keycode == 111) {
                        parent.getListener().onEndKeyCatching(parent, parent.deviceType, -1);
                        return false;
                    }
                    parent.deviceType = DeviceType.KEYBOARD;
                    parent.keyCode = keycode;
                    parent.getListener().onEndKeyCatching(parent, parent.deviceType, keycode);
                    event.stop();
                    return true;
                }
            };
            this.parent.addListener(this.keyBoardCatcher);
        }
    }

    public static interface KeyCatcherListener {
        public void onStartKeyCatching(KeyCatcherComponent var1);

        public void onEndKeyCatching(KeyCatcherComponent var1, DeviceType var2, int var3);
    }
}

