/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui;

import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.util.StandardFormats;

public class TextButtonPalette<ITEM>
extends Palette<AstraXTextButton, ITEM> {
    public TextButtonPalette(ComponentFactory factory) {
        super(factory);
        this.buttonUpdater = new Palette.ButtonUpdater<AstraXTextButton, ITEM>(){

            @Override
            public AstraXTextButton createButton(ComponentFactory componentFactory, String style) {
                return new AstraXTextButton(componentFactory, style);
            }

            @Override
            public void updateButton(AstraXTextButton button, ITEM item) {
                button.setUserObject(item);
                if (item instanceof Item) {
                    button.setText(StandardFormats.FLOAT_COUNT.format(Float.valueOf(((Item)item).getAmount())));
                }
                if (item instanceof Module) {
                    ModuleSettings moduleSettings = ((Module)item).getModuleSettings();
                    button.getStyle().iconColor.upColor = moduleSettings.color.cpy();
                    button.setInlineIcon(new TextureRegionDrawable(AstraXApp.astraX.getCoreDataPack().getTexture(moduleSettings.textureRegion)));
                }
            }

            @Override
            public void resetButton(AstraXTextButton button) {
                button.setText("");
                button.setInlineIcon(null);
                button.setUserObject(null);
            }
        };
    }
}

