/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.Background;

public abstract class AstraXComponent
extends Table {
    protected ComponentFactory componentFactory;
    protected Background background;

    public AstraXComponent(ComponentFactory componentFactory) {
        this(componentFactory, null);
    }

    public AstraXComponent(ComponentFactory componentFactory, String backgroundStyle) {
        super(componentFactory.getSkin());
        this.componentFactory = componentFactory;
        if (backgroundStyle != null) {
            this.background = new Background(componentFactory.getSkin(), backgroundStyle);
            this.pad(this.background.getStyle().padding);
        }
    }

    public Background.BackgroundStyle getBackgroundStyle() {
        return this.background.style;
    }

    public void setBackgroundStyle(Background.BackgroundStyle style) {
        if (style == null && this.background != null) {
            this.background.remove();
            return;
        }
        if (this.background != null) {
            this.background.setStyle(style);
        } else {
            this.background = new Background(this.componentFactory.getSkin(), style);
            this.addActor(this.background);
            this.background.toBack();
        }
        this.pad(style.padding);
    }

    @Override
    public void setBackground(Drawable background) {
        throw new UnsupportedOperationException("Do not use this method. Use the Background class instead");
    }

    @Override
    public void setBackground(String drawableName) {
        throw new UnsupportedOperationException("Do not use this method. Use the Background class instead");
    }

    public void construct() {
        if (this.background != null) {
            this.addActor(this.background);
            this.background.toBack();
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.background != null) {
            this.background.setSize(this.getWidth(), this.getHeight());
        }
    }

    protected String getTranslation(String identifier) {
        return this.componentFactory.translate(identifier);
    }
}

