/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.ui.commons.buttons.ReactiveColor;

public class Background
extends Image {
    protected BackgroundStyle style;
    protected Color currentColor;
    private ReactiveColor.ReactiveState state = ReactiveColor.ReactiveState.UP;

    public Background(Skin skin) {
        this(skin, "default");
    }

    public Background(Skin skin, BackgroundStyle backgroundStyle) {
        this.setStyle(backgroundStyle);
    }

    public Background(Skin skin, String style) {
        this.setStyle(skin.get(style, BackgroundStyle.class));
    }

    public void setState(ReactiveColor.ReactiveState state) {
        this.state = state;
        this.currentColor = this.style.color.getColor(this.state);
        this.setColor(this.currentColor);
    }

    public ReactiveColor.ReactiveState getState() {
        return this.state;
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public BackgroundStyle getStyle() {
        return this.style;
    }

    public void setStyle(BackgroundStyle style) {
        this.style = style;
        this.setDrawable(style.background);
        this.currentColor = style.color.getColor(this.state);
        this.setColor(this.currentColor);
    }

    public static class BackgroundStyle {
        public ReactiveColor color;
        public Drawable background;
        public int padding = 0;

        public BackgroundStyle copy() {
            BackgroundStyle copy = new BackgroundStyle();
            copy.background = this.background;
            copy.color = this.color.copy();
            copy.padding = this.padding;
            return copy;
        }
    }
}

