/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.editor.Palette;
import java.util.Objects;

public class ColorPalette
extends Palette<AstraXButton, Color> {
    public ColorPalette(ComponentFactory componentFactory) {
        super(componentFactory);
        this.setIconCount(10);
        this.buttonUpdater = new Palette.ButtonUpdater<AstraXButton, Color>(){

            @Override
            public AstraXButton createButton(ComponentFactory componentFactory, String style) {
                AstraXButton button = new AstraXButton(componentFactory, "color");
                button.setStyle(button.getStyle().copy());
                button.setCanCheck(true);
                button.setDisabled(true);
                button.setUserObject(null);
                return button;
            }

            @Override
            public void updateButton(AstraXButton button, Color color) {
                button.setDisabled(false);
                ColorPalette.this.updateButtonStyle(button, color);
            }

            @Override
            public void resetButton(AstraXButton button) {
                button.setDisabled(true);
                button.setUserObject(null);
            }
        };
    }

    public AstraXButton getSelectedButton() {
        return (AstraXButton)this.buttonGroup.getChecked();
    }

    public void updateButtonStyle(AstraXButton button, Color color) {
        if (Objects.equals(color, Color.WHITE)) {
            System.out.println("Derp");
        }
        button.getStyle().baseColor.upColor = color.cpy();
        button.getStyle().baseColor.downColor = color.cpy().mul(0.9f);
        button.getStyle().baseColor.overColor = color.mul(1.1f);
        button.getStyle().baseColor.checkedColor = color.cpy();
        button.getStyle().baseColor.checkedOverColor = color.mul(1.1f);
        button.getStyle().baseColor.checkedDownColor = color.cpy().mul(0.9f);
    }
}

