/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import java.util.logging.Logger;

public class Dragger
extends InputListener {
    private Logger logger = Logger.getLogger(Dragger.class.getCanonicalName());
    public float dragSpeed = 2.5f;
    private float dragOffsetx = 0.0f;
    private float dragOffsety = 0.0f;
    private float dragX;
    private float dragY;
    private int button = 1;
    protected boolean dragging;

    @Override
    public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
        if (pointer == 0 && this.button != -1 && this.button != button) {
            return false;
        }
        this.dragOffsetx -= x * this.dragSpeed;
        this.dragOffsety -= y * this.dragSpeed;
        this.dragging = true;
        return true;
    }

    @Override
    public void touchDragged(InputEvent event, float x, float y, int pointer) {
        if (this.button != this.button) {
            return;
        }
        if (!this.dragging) {
            this.dragging = true;
            this.dragX = x;
            this.dragY = y;
        }
        if (this.dragging) {
            this.dragX = x;
            this.dragY = y;
        }
    }

    @Override
    public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
        if (this.button == button) {
            if (this.dragging) {
                this.dragOffsetx += this.dragX * this.dragSpeed;
                this.dragOffsety += this.dragY * this.dragSpeed;
            }
            this.dragging = false;
        }
    }

    public float getDragOffsetx() {
        return this.dragging ? this.dragOffsetx + this.dragX * this.dragSpeed : this.dragOffsetx;
    }

    public float getDragOffsety() {
        return this.dragging ? this.dragOffsety + this.dragY * this.dragSpeed : this.dragOffsety;
    }
}

