/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.ParallelAction;

@Deprecated
public class FadeController<T extends Actor> {
    private float fadeInDuration = 0.2f;
    private float fadeOutDuration = 0.7f;
    private float settleDuration = 2.0f;
    private FadeState fadeState = FadeState.FADE_END;
    private float timer = 0.0f;
    private Vector2 relativePositionChange = new Vector2();
    private T actor;

    public FadeController(T actor) {
        this.actor = actor;
    }

    public FadeState getFadeState() {
        return this.fadeState;
    }

    public void setActor(T actor) {
        this.actor = actor;
    }

    public float getFadeInDuration() {
        return this.fadeInDuration;
    }

    public void setFadeInDuration(float fadeInDuration) {
        this.fadeInDuration = fadeInDuration;
    }

    public float getFadeOutDuration() {
        return this.fadeOutDuration;
    }

    public void setFadeOutDuration(float fadeOutDuration) {
        this.fadeOutDuration = fadeOutDuration;
    }

    public void setRelativePositionChange(float x, float y) {
        this.relativePositionChange.set(x, y);
    }

    public boolean startFadeIn(float settleDuration) {
        if (this.fadeState.ordinal() != FadeState.FADE_END.ordinal()) {
            return false;
        }
        this.settleDuration = settleDuration;
        this.fadeState = FadeState.FADE_IN;
        this.timer = this.fadeInDuration;
        ParallelAction parallel = Actions.parallel((Action)Actions.fadeIn(this.fadeInDuration), (Action)Actions.moveBy(this.relativePositionChange.x, this.relativePositionChange.y, this.fadeInDuration));
        ((Actor)this.actor).addAction(parallel);
        return true;
    }

    private void startFadeOut() {
        this.fadeState = FadeState.FADE_OUT;
        this.timer = this.fadeOutDuration;
        ParallelAction parallel = Actions.parallel((Action)Actions.fadeOut(this.fadeOutDuration), (Action)Actions.moveBy(-this.relativePositionChange.x, -this.relativePositionChange.y, this.fadeOutDuration));
        ((Actor)this.actor).addAction(parallel);
    }

    public void update(float delta) {
        if (this.timer < -9.0f) {
            return;
        }
        this.timer -= delta;
        if (this.timer < 0.0f) {
            switch (this.fadeState) {
                case FADE_IN: {
                    this.fadeState = FadeState.FADE_SETTLE;
                    this.timer = this.settleDuration;
                    break;
                }
                case FADE_SETTLE: {
                    this.startFadeOut();
                    break;
                }
                case FADE_OUT: {
                    this.fadeState = FadeState.FADE_END;
                    this.timer = -10.0f;
                    break;
                }
            }
        }
    }

    public static enum FadeState {
        FADE_IN,
        FADE_SETTLE,
        FADE_OUT,
        FADE_END;

    }
}

