/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.util.Vector2i;
import com.neutronio.astrax.util.collections.Grid;
import java.util.logging.Logger;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class GridComponent<G extends GridTile>
extends Group {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    protected ComponentFactory componentFactory;
    protected int tileSize = 16;
    protected boolean showGrid = true;
    protected GridComponentStyle style;
    protected float time;
    protected int bounce = 0;
    protected Grid<G> data;
    protected Vector2i selectedTile;
    protected HoverTile hoverTile;

    public GridComponent(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
        this.addListener(new ClickListener(){

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                super.touchUp(event, x, y, pointer, button);
                int xTile = (int)x / GridComponent.this.tileSize;
                int yTile = (int)y / GridComponent.this.tileSize;
                GridComponent.this.selectTile(xTile, yTile);
            }
        });
        this.hoverTile = new HoverTile();
        this.addListener(this.hoverTile);
        this.setStyle(componentFactory.getSkin().get(GridComponentStyle.class));
    }

    public GridComponentStyle getStyle() {
        return this.style;
    }

    public void setStyle(GridComponentStyle style) {
        this.style = style;
        this.hoverTile.color = style.hoverTileColor;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    protected void selectTile(int xTile, int yTile) {
        if (this.selectedTile == null) {
            this.logger.fine("New selected tile " + xTile + " " + yTile);
            this.selectedTile = new Vector2i(xTile, yTile);
            AstraXApp.astraX.getUiSoundManager().playSoundOnce(this.getStyle().soundSelect);
        } else if (this.selectedTile.x == xTile && this.selectedTile.y == yTile) {
            this.logger.fine("Deselect tile " + xTile + " " + yTile);
            this.selectedTile = null;
        } else {
            this.logger.fine("Setting tile " + xTile + " " + yTile);
            this.selectedTile.set(xTile, yTile);
            AstraXApp.astraX.getUiSoundManager().playSoundOnce(this.getStyle().soundSelect);
        }
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        this.fire(changeEvent);
        Pools.free(changeEvent);
    }

    public Vector2i getSelectedTile() {
        return this.selectedTile;
    }

    public int getWidthInTiles() {
        return this.data.getWidth();
    }

    public int getHeightInTiles() {
        return this.data.getHeight();
    }

    public Grid<G> getData() {
        return this.data;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.render(batch, this.componentFactory.getUiRenderContext().getShapeDrawer(), parentAlpha);
    }

    public void render(Batch batch, ShapeDrawer shapeDrawer, float parentAlpha) {
        int y;
        int x;
        float delta = Gdx.graphics.getDeltaTime();
        this.time += delta * 3.0f;
        if (this.showGrid) {
            shapeDrawer.setDefaultLineWidth(1.0f);
            shapeDrawer.setColor(this.style.gridColor.r, this.style.gridColor.g, this.style.gridColor.b, 0.8f);
            for (x = 0; x < this.data.getWidth() + 1; ++x) {
                shapeDrawer.line(this.getX() + (float)(x * this.tileSize) * this.getScaleX(), this.getY(), this.getX() + (float)(x * this.tileSize) * this.getScaleX(), this.getY() + (float)(this.data.getHeight() * this.tileSize) * this.getScaleY());
                for (y = 0; y < this.data.getHeight() + 1; ++y) {
                    shapeDrawer.line(this.getX(), this.getY() + (float)(y * this.tileSize) * this.getScaleY(), this.getX() + (float)(this.data.getWidth() * this.tileSize) * this.getScaleX(), this.getY() + (float)(y * this.tileSize) * this.getScaleY());
                }
            }
        }
        for (x = 0; x < this.data.getWidth(); ++x) {
            for (y = 0; y < this.data.getHeight(); ++y) {
                GridTile gridTile = (GridTile)this.data.get(x, y);
                gridTile.render(batch, this.getX() + (float)(x * this.tileSize) * this.getScaleX(), this.getY() + (float)(y * this.tileSize) * this.getScaleY(), (float)this.tileSize * this.getScaleX() / 2.0f, (float)this.tileSize * this.getScaleY() / 2.0f, (float)this.tileSize * this.getScaleX(), (float)this.tileSize * this.getScaleY(), parentAlpha);
            }
        }
        if (this.selectedTile != null) {
            this.bounce = (int)Interpolation.sine.apply(0.0f, 15.0f, this.time);
            shapeDrawer.setColor(this.style.selectedTileColor.r, this.style.selectedTileColor.g, this.style.selectedTileColor.b, MathUtils.lerp(0.1f, 1.0f, Interpolation.sine.apply(this.time)));
            shapeDrawer.setDefaultLineWidth(3.0f);
            shapeDrawer.rectangle(this.getX() + (float)(this.selectedTile.x * this.tileSize) * this.getScaleX(), this.getY() + (float)(this.selectedTile.y * this.tileSize) * this.getScaleY(), (float)this.tileSize * this.getScaleX(), (float)this.tileSize * this.getScaleY());
            shapeDrawer.rectangle(this.getX() + (float)(this.selectedTile.x * this.tileSize) * this.getScaleX() - (float)this.bounce / 2.0f * 0.5f, this.getY() + (float)(this.selectedTile.y * this.tileSize) * this.getScaleY() - (float)this.bounce / 2.0f * 0.5f, (float)this.tileSize * this.getScaleX() + (float)this.bounce * 0.5f, (float)this.tileSize * this.getScaleY() + (float)this.bounce * 0.5f);
            shapeDrawer.setDefaultLineWidth(1.0f);
        }
        if (this.hoverTile != null) {
            this.hoverTile.render(batch, shapeDrawer, this.time);
        }
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
    }

    public class HoverTile
    extends ClickListener {
        public Vector2i location = new Vector2i(0, 0);
        public Color color = Color.PURPLE;

        public void render(Batch batch, ShapeDrawer shapeDrawer, float time) {
            float guideAlpha = Interpolation.sine.apply(time * 0.7f);
            shapeDrawer.setColor(this.color.r, this.color.g, this.color.b, guideAlpha);
            shapeDrawer.setDefaultLineWidth(3.0f);
            shapeDrawer.filledRectangle(GridComponent.this.getX() + (float)(this.location.x * GridComponent.this.tileSize) * GridComponent.this.getScaleX(), GridComponent.this.getY() + (float)(this.location.y * GridComponent.this.tileSize) * GridComponent.this.getScaleY(), (float)GridComponent.this.tileSize * GridComponent.this.getScaleX(), (float)GridComponent.this.tileSize * GridComponent.this.getScaleY());
        }

        @Override
        public boolean mouseMoved(InputEvent event, float x, float y) {
            this.location.x = (int)x / GridComponent.this.tileSize;
            this.location.y = (int)y / GridComponent.this.tileSize;
            return super.mouseMoved(event, x, y);
        }
    }

    public static class GridComponentStyle {
        public Color hoverTileColor;
        public Color selectedTileColor;
        public Color currentLocationColor;
        public Color gridColor;
        public String soundSelect;
        public String soundZoomIn;
        public String soundZoomOut;
    }

    public static interface GridTile {
        public void render(Batch var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);
    }
}

