/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.util.animation.Tweening;

public class IconLabel
extends AstraXComponent {
    protected Label label;
    protected StaticIcon staticIcon;
    protected IconLabelStyle iconLabelStyle;

    public IconLabel(ComponentFactory factory) {
        this(factory, "default", null);
    }

    public IconLabel(ComponentFactory factory, String styleName) {
        this(factory, styleName, null);
    }

    public IconLabel(ComponentFactory factory, String styleName, String backgroundName) {
        super(factory, backgroundName);
        this.iconLabelStyle = factory.getSkin().get(styleName, IconLabelStyle.class);
        this.staticIcon = new StaticIcon(this.iconLabelStyle.iconStyle);
        this.staticIcon.setSkin(factory.getSkin());
        this.staticIcon.setOrigin(this.staticIcon.getWidth() / 2.0f, this.staticIcon.getHeight() / 2.0f);
        this.label = new Label((CharSequence)"", factory.getSkin(), this.iconLabelStyle.font, this.iconLabelStyle.fontColor);
        this.label.setAlignment(1, 1);
        this.construct();
        this.add(this.label).minSize(this.iconLabelStyle.labelMinWidth, 20.0f).align(1);
        this.add(this.staticIcon).padLeft(this.iconLabelStyle.iconPadding);
        this.pack();
        this.setStyle(this.iconLabelStyle);
    }

    public IconLabelStyle getStyle() {
        return this.iconLabelStyle;
    }

    public void squishIcon() {
        this.staticIcon.addAction(Actions.repeat(3, Tweening.getSquish(3.0f)));
    }

    public void setLabelAlign(int labelAlign) {
        this.getCell(this.label).align(labelAlign);
        this.label.setAlignment(labelAlign);
        this.label.setAlignment(labelAlign, labelAlign);
    }

    public void setStyle(IconLabelStyle iconLabelStyle) {
        this.iconLabelStyle = iconLabelStyle;
        this.staticIcon.setStyle(iconLabelStyle.iconStyle);
        this.label.setStyle(new Label.LabelStyle(this.getSkin().getFont(this.iconLabelStyle.font), this.getSkin().getColor(this.iconLabelStyle.fontColor)));
    }

    public void setIconVisible(boolean visible) {
        this.staticIcon.setVisible(visible);
    }

    public void set(String iconDrawable, String text) {
        this.staticIcon.setInlineIcon(iconDrawable);
        this.label.setText(text);
    }

    public void setIcon(String iconDrawable) {
        this.staticIcon.setInlineIcon(iconDrawable);
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    @Override
    protected void drawBackground(Batch batch, float parentAlpha, float x, float y) {
        if (this.getBackground() == null) {
            return;
        }
        Color color = this.iconLabelStyle.backgroundColor != null ? this.iconLabelStyle.backgroundColor : this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha * this.getColor().a);
        this.getBackground().draw(batch, x, y, this.getWidth(), this.getHeight());
        batch.setColor(Color.WHITE);
    }

    public static class IconLabelStyle {
        public String font;
        public String fontColor = "white";
        public StaticIcon.StaticIconStyle iconStyle;
        public int labelMinWidth = 200;
        public int iconPadding = 10;
        @Deprecated
        public String background;
        @Deprecated
        public Color backgroundColor;
    }
}

