/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.Background;

public class ProgressBar
extends WidgetGroup {
    private static final float MIN = 0.0f;
    private static final float MAX = 1.0f;
    private ComponentFactory componentFactory;
    private float value;
    private float targetValue;
    protected Background bar;
    protected Background background;
    protected ProgressBarStyle style;

    public ProgressBar(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
        this.bar = new Background(componentFactory.getSkin());
        this.background = new Background(componentFactory.getSkin());
        this.setStyle(componentFactory.getSkin().get("default", ProgressBarStyle.class));
        this.addActor(this.background);
        this.addActor(this.bar);
    }

    public void setStyle(ProgressBarStyle style) {
        this.style = style;
        this.background.setStyle(style.backgroundStyle);
        this.bar.setStyle(style.barStyle);
    }

    public float getValue() {
        return this.value;
    }

    public float getTargetValue() {
        return this.targetValue;
    }

    public void setValue(float value) {
        this.targetValue = MathUtils.clamp(value, 0.0f, 1.0f);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.value = this.value * 0.9f + this.targetValue * 0.1f;
        int barWidth = (int)MathUtils.clamp(this.getWidth() * this.value, this.bar.getDrawable().getMinWidth(), this.getWidth());
        this.bar.setSize(barWidth, this.getHeight());
        this.background.setSize(this.getWidth(), this.getHeight());
        super.draw(batch, parentAlpha);
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        return 20.0f;
    }

    @Override
    public float getMaxWidth() {
        return 300.0f;
    }

    @Override
    public float getMaxHeight() {
        return 32.0f;
    }

    public static class ProgressBarStyle {
        Background.BackgroundStyle backgroundStyle;
        Background.BackgroundStyle barStyle;
    }
}

