/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.ReactiveColor;
import com.neutronio.astrax.util.Vector2i;
import java.util.Objects;

public class Scrollbar
extends Table {
    ComponentFactory factory;
    Vector2i direction = new Vector2i(0, 1);
    int offset = 0;
    int max = 0;
    AstraXButton nextButton;
    AstraXButton prevButton;
    Group scrollArea;
    Image scrollbar;
    Image background;
    ScrollbarStyle style;

    public Scrollbar(ComponentFactory componentFactory, String style) {
        super(componentFactory.getSkin());
        this.factory = componentFactory;
        this.addListener(new DragListener(){

            @Override
            public void drag(InputEvent event, float x, float y, int pointer) {
                super.drag(event, x, y, pointer);
                if (this.isDragging()) {
                    if (Scrollbar.this.direction.y == 1) {
                        if (this.getDeltaY() > 0.0f && this.getDeltaY() % 4.0f == 0.0f) {
                            Scrollbar.this.previous();
                            Scrollbar.this.applyActionsToScrollbar();
                            Scrollbar.this.factory.playUISound("button_click2");
                            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                            Scrollbar.this.fire(changeEvent);
                            Pools.free(changeEvent);
                        } else if (this.getDeltaY() < 0.0f && this.getDeltaY() % 4.0f == 0.0f) {
                            Scrollbar.this.next();
                            Scrollbar.this.applyActionsToScrollbar();
                            Scrollbar.this.factory.playUISound("button_click2");
                            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                            Scrollbar.this.fire(changeEvent);
                            Pools.free(changeEvent);
                        }
                    } else if (Scrollbar.this.direction.x == 1) {
                        if (this.getDeltaX() > 0.0f && this.getDeltaX() % 4.0f == 0.0f) {
                            Scrollbar.this.next();
                            Scrollbar.this.applyActionsToScrollbar();
                            Scrollbar.this.factory.playUISound("button_click2");
                            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                            Scrollbar.this.fire(changeEvent);
                            Pools.free(changeEvent);
                        } else if (this.getDeltaX() < 0.0f && this.getDeltaX() % 4.0f == 0.0f) {
                            Scrollbar.this.previous();
                            Scrollbar.this.applyActionsToScrollbar();
                            Scrollbar.this.factory.playUISound("button_click2");
                            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                            Scrollbar.this.fire(changeEvent);
                            Pools.free(changeEvent);
                        }
                    }
                }
            }

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                if (amountY > 0.0f) {
                    Scrollbar.this.previous();
                    Scrollbar.this.applyActionsToScrollbar();
                    Scrollbar.this.factory.playUISound("button_click2");
                    ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                    Scrollbar.this.fire(changeEvent);
                    Pools.free(changeEvent);
                    return true;
                }
                if (amountY < 0.0f) {
                    Scrollbar.this.next();
                    Scrollbar.this.applyActionsToScrollbar();
                    Scrollbar.this.factory.playUISound("button_click2");
                    ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                    Scrollbar.this.fire(changeEvent);
                    Pools.free(changeEvent);
                    return true;
                }
                return false;
            }
        });
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                Scrollbar.this.obtainScrollFocus();
            }
        });
        this.scrollArea = new Group();
        this.nextButton = new AstraXButton(componentFactory, "primary");
        this.nextButton.setCanCheck(false);
        this.nextButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                Scrollbar.this.next();
                Scrollbar.this.applyActionsToScrollbar();
                ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                Scrollbar.this.fire(changeEvent);
                Pools.free(changeEvent);
            }
        });
        this.prevButton = new AstraXButton(componentFactory, "primary");
        this.prevButton.setCanCheck(false);
        this.prevButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (Objects.equals(event.getListenerActor(), Scrollbar.this.prevButton)) {
                    Scrollbar.this.previous();
                    Scrollbar.this.applyActionsToScrollbar();
                    ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                    Scrollbar.this.fire(changeEvent);
                    Pools.free(changeEvent);
                }
            }
        });
        this.scrollbar = new Image(componentFactory.getSkin().getPatch("background_rect"));
        this.scrollbar.setColor(Color.GOLD);
        this.background = new Image(componentFactory.getSkin().getPatch("background_rect_outline_icon"));
        this.background.setColor(Color.BLUE);
        this.setStyle(componentFactory.getSkin().get(style, ScrollbarStyle.class));
        this.scrollArea.addActor(this.scrollbar);
        this.applyActionsToScrollbar();
        this.setDirection(1, 0);
    }

    public ScrollbarStyle getStyle() {
        return this.style;
    }

    public void setStyle(ScrollbarStyle style) {
        this.style = style;
        this.nextButton.setStyle(style.nextButtonStyle);
        this.prevButton.setStyle(style.nextButtonStyle);
        this.scrollbar = new Image(style.scrollbar);
        this.scrollbar.setColor(style.scrollBarColor.getColor(ReactiveColor.ReactiveState.UP));
        this.background = new Image(style.background);
        this.background.setColor(style.backgroundColor.getColor(ReactiveColor.ReactiveState.UP));
        this.nextButton.setInlineIcon(this.factory.getSkin().getDrawable("icon_inline_arrow_up"));
        this.prevButton.setInlineIcon(this.factory.getSkin().getDrawable("icon_inline_arrow_down"));
    }

    public void setDirection(int x, int y) {
        if (x == 1 && y == 1) {
            return;
        }
        this.clear();
        if (x > 0) {
            this.direction.set(1, 0);
            this.nextButton.setInlineIcon(this.factory.getSkin().getDrawable("icon_inline_arrow_right"));
            this.prevButton.setInlineIcon(this.factory.getSkin().getDrawable("icon_inline_arrow_left"));
            this.add(this.prevButton);
            this.add(this.scrollArea).growX();
            this.add(this.nextButton);
            this.pack();
        }
        if (y > 0) {
            this.direction.set(0, 1);
            this.nextButton.setInlineIcon(this.factory.getSkin().getDrawable("icon_inline_arrow_down"));
            this.prevButton.setInlineIcon(this.factory.getSkin().getDrawable("icon_inline_arrow_up"));
            this.add(this.prevButton);
            this.row();
            this.add(this.scrollArea).growY();
            this.row();
            this.add(this.nextButton);
            this.pack();
        }
    }

    @Override
    protected void sizeChanged() {
        super.sizeChanged();
        float width = this.getWidth();
        float height = this.getHeight();
        this.background.setSize(width, height);
        float scrollWidth = width - this.prevButton.getWidth() * 2.0f * (float)this.direction.x;
        float scrollHeight = height - this.prevButton.getHeight() * 2.0f * (float)this.direction.y;
        this.getCell(this.scrollArea).maxSize(scrollWidth, scrollHeight).minSize(this.prevButton.getWidth(), this.prevButton.getHeight());
        this.updateScrollbarSize();
    }

    private void updateScrollbarSize() {
        if (this.direction.x > 0 && this.max > 0) {
            float scrollBarWidth = MathUtils.clamp(this.getCell(this.scrollArea).getPrefWidth() / (float)(this.max + 1), 28.0f, this.getCell(this.scrollArea).getPrefWidth());
            if (this.max > 1) {
                this.scrollbar.setSize(scrollBarWidth, this.prevButton.getHeight());
                this.scrollbar.setAlign(1);
                this.scrollbar.setOrigin(this.getCell(this.scrollArea).getPrefWidth() / 2.0f, this.getCell(this.scrollArea).getPrefHeight() / 2.0f);
            } else {
                this.scrollbar.setSize(scrollBarWidth, this.prevButton.getHeight());
            }
        } else if (this.direction.y > 0) {
            float scrollBarHeight = MathUtils.clamp(this.getCell(this.scrollArea).getPrefHeight() / (float)(this.max + 1), 28.0f, this.getCell(this.scrollArea).getPrefHeight());
            if (this.max > 0) {
                this.scrollbar.setSize(this.prevButton.getWidth(), scrollBarHeight);
                this.scrollbar.setAlign(1);
                this.scrollbar.setOrigin(this.getCell(this.scrollArea).getPrefWidth() / 2.0f, this.getCell(this.scrollArea).getPrefHeight() / 2.0f);
            } else {
                this.scrollbar.setSize(this.prevButton.getWidth(), scrollBarHeight);
            }
        }
    }

    public void setMax(int max) {
        this.max = max;
        this.offset = MathUtils.clamp(this.offset, 0, this.max);
        this.updateScrollbarSize();
        this.applyActionsToScrollbar();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.applyActionsToScrollbar();
    }

    public void next() {
        this.offset = MathUtils.clamp(this.offset + 1, 0, this.max);
    }

    public void previous() {
        this.offset = MathUtils.clamp(this.offset - 1, 0, this.max);
    }

    private void obtainScrollFocus() {
        if (!this.hasScrollFocus()) {
            this.getStage().setScrollFocus(this);
        } else {
            this.getStage().setScrollFocus(null);
        }
    }

    public void applyActionsToScrollbar() {
        if (this.direction.x > 0 && this.max > 0) {
            this.scrollbar.addAction(Actions.moveTo((float)this.offset / (float)(this.max + 1) * this.scrollArea.getWidth(), 0.0f, 0.2f, Interpolation.pow2));
        } else if (this.direction.y > 0 && this.max > 0) {
            this.scrollbar.addAction(Actions.moveTo(0.0f, this.scrollArea.getHeight() - (float)this.offset / (float)(this.max + 1) * this.scrollArea.getHeight() - this.scrollbar.getHeight(), 0.2f, Interpolation.pow2));
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.hasScrollFocus()) {
            this.scrollbar.setColor(this.style.scrollBarColor.getColor(ReactiveColor.ReactiveState.CHECKED_OVER));
            this.background.setColor(this.style.backgroundColor.getColor(ReactiveColor.ReactiveState.CHECKED));
        } else {
            this.scrollbar.setColor(this.style.scrollBarColor.getColor(ReactiveColor.ReactiveState.UP));
            this.background.setColor(this.style.backgroundColor.getColor(ReactiveColor.ReactiveState.UP));
        }
    }

    @Override
    protected void drawChildren(Batch batch, float parentAlpha) {
        this.background.setPosition(this.getX(), this.getY());
        this.background.draw(batch, parentAlpha);
        super.drawChildren(batch, parentAlpha);
    }

    public static class ScrollbarStyle {
        AstraXButton.AstraXButtonStyle nextButtonStyle;
        Drawable nextInlineIcon;
        AstraXButton.AstraXButtonStyle previousButtonStyle;
        Drawable previousInlineIcon;
        Drawable scrollbar;
        ReactiveColor scrollBarColor;
        Drawable background;
        ReactiveColor backgroundColor;
        ReactiveColor backgroundfocusColor;
    }
}

