/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.util.animation.Tweening;
import java.util.ArrayList;
import java.util.List;

public class SelectBox<E>
extends AstraXTextButton {
    private ComponentFactory factory;
    private ButtonGroup<AstraXTextButton> buttonSelection = new ButtonGroup();
    private SimplePanel dropDown;
    private List<SelectBoxWrapper<E>> contents = new ArrayList<SelectBoxWrapper<E>>();
    private ClickListener hideListener;
    private boolean expanded = false;
    private int maxWidth = -1;

    public SelectBox(ComponentFactory componentFactory) {
        super(componentFactory, null, "dropDown");
        this.factory = componentFactory;
        this.setCanCheck(false);
        this.buttonSelection.setMinCheckCount(0);
        this.buttonSelection.setMaxCheckCount(1);
        this.buttonSelection.setUncheckLast(true);
        this.removeListener(this.clickListener);
        this.clickListener = new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (SelectBox.this.isDisabled()) {
                    return false;
                }
                event.setBubbles(false);
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (SelectBox.this.isDisabled()) {
                    return;
                }
                event.setBubbles(false);
                super.touchUp(event, x, y, pointer, button);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                super.enter(event, x, y, pointer, fromActor);
                if (SelectBox.this.isDisabled()) {
                    return;
                }
                event.setBubbles(false);
                if (((SelectBox)SelectBox.this).style.buttonSounds.soundOver != null && pointer < 0) {
                    SelectBox.this.factory.playUISound(((SelectBox)SelectBox.this).style.buttonSounds.soundOver);
                }
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                super.exit(event, x, y, pointer, toActor);
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (SelectBox.this.isDisabled()) {
                    return;
                }
                if (SelectBox.this.expanded) {
                    SelectBox.this.expanded = false;
                    SelectBox.this.dropDown.addAction(Tweening.getDropDownFadeOut(0.3f));
                } else {
                    SelectBox.this.expanded = true;
                    SelectBox.this.dropDown.toFront();
                    SelectBox.this.dropDown.setPosition(0.0f, 0.0f, 10);
                    SelectBox.this.dropDown.addAction(Tweening.getDropDownFadeIn(0.1f));
                }
                if (!SelectBox.this.isChecked()) {
                    SelectBox.this.label.addAction(Tweening.getSquish(1.0f, null));
                } else {
                    SelectBox.this.label.addAction(Tweening.getSquish(0.2f));
                }
                if (!SelectBox.this.canCheck()) {
                    return;
                }
                SelectBox.this.setChecked(!SelectBox.this.isChecked(), true);
            }
        };
        this.addListener(this.clickListener);
        this.hideListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                event.setBubbles(false);
                if (SelectBox.this.buttonSelection.getChecked() != null) {
                    SelectBox.this.setText(((AstraXTextButton)SelectBox.this.buttonSelection.getChecked()).getText());
                } else {
                    SelectBox.this.setText("");
                }
                SelectBox.this.dropDown.addAction(Tweening.getDropDownFadeOut(0.3f));
                event.handle();
            }
        };
        this.dropDown = new SimplePanel(componentFactory, "list", "selectbox-body");
        this.dropDown.setTouchable(Touchable.disabled);
        this.dropDown.setVisible(false);
        this.addActor(this.dropDown);
    }

    @Override
    public float getPrefWidth() {
        return this.maxWidth;
    }

    public void updateToContent() {
        for (AstraXTextButton button : this.buttonSelection.getButtons()) {
            button.remove();
        }
        this.buttonSelection.clear();
        for (SelectBoxWrapper<E> wrapper : this.contents) {
            AstraXTextButton button = new AstraXTextButton(this.factory, wrapper.toString(), null, "selectbox");
            button.setText(wrapper.toString());
            button.addListener(this.hideListener);
            this.maxWidth = (int)Math.max((float)this.maxWidth, button.getPrefWidth());
            this.buttonSelection.add(button);
            this.dropDown.addValue(button).center();
            this.dropDown.row();
        }
        this.dropDown.pack();
        this.invalidate();
    }

    public void setContents(List<SelectBoxWrapper<E>> content) {
        this.contents.clear();
        this.contents.addAll(content);
    }

    public void addToContents(List<SelectBoxWrapper<E>> content) {
        this.contents.addAll(content);
    }

    public void addToContent(SelectBoxWrapper<E> content) {
        this.contents.add(content);
    }
}

