/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.buttons;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.sfx.ButtonSounds;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.BaseButton;
import com.neutronio.astrax.ui.commons.buttons.ReactiveColor;
import com.neutronio.astrax.util.animation.Tweening;

public class AstraXButton
extends BaseButton {
    protected ComponentFactory factory;
    protected AstraXButtonStyle style;
    private Image baseImage;
    private Image iconImage;

    public AstraXButton(ComponentFactory factory, String buttonStyle) {
        this(factory, null, buttonStyle);
    }

    public AstraXButton(ComponentFactory cfactory, String iconDrawable, String buttonStyle) {
        this.factory = cfactory;
        this.baseImage = new Image();
        this.addActor(this.baseImage);
        this.iconImage = new Image();
        this.iconImage.setTouchable(Touchable.disabled);
        this.addActor(this.iconImage);
        AstraXButtonStyle iconStyle = this.factory.getSkin().get(buttonStyle, AstraXButtonStyle.class).copy();
        this.setStyle(iconStyle);
        if (iconDrawable != null) {
            this.setInlineIcon(this.factory.getSkin().getDrawable(iconDrawable));
        }
        this.clickListener = new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (AstraXButton.this.isDisabled()) {
                    return false;
                }
                if (AstraXButton.this.style.buttonSounds.soundPressed != null) {
                    AstraXButton.this.factory.playUISound(AstraXButton.this.style.buttonSounds.soundPressed);
                }
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (AstraXButton.this.isDisabled()) {
                    return;
                }
                if (AstraXButton.this.style.buttonSounds.soundRelease != null) {
                    AstraXButton.this.factory.playUISound(AstraXButton.this.style.buttonSounds.soundRelease);
                }
                super.touchUp(event, x, y, pointer, button);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                super.enter(event, x, y, pointer, fromActor);
                if (AstraXButton.this.style.buttonSounds.soundOver != null && pointer < 0) {
                    AstraXButton.this.factory.playUISound(AstraXButton.this.style.buttonSounds.soundOver);
                }
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (AstraXButton.this.isDisabled() && !AstraXButton.this.canCheck()) {
                    return;
                }
                if (!AstraXButton.this.isChecked()) {
                    AstraXButton.this.doSquish(3.125f, true);
                } else {
                    AstraXButton.this.doSquish(1.0f, true);
                }
                AstraXButton.this.setChecked(!AstraXButton.this.isChecked(), true);
            }
        };
        this.addListener(this.clickListener);
    }

    public void doSquish(float strength, boolean invokeAction) {
        if (invokeAction) {
            this.baseImage.addAction(Tweening.getSquish(0.8f * strength, this.buttonAction));
            this.iconImage.addAction(Tweening.getSquish(0.2f * strength));
        } else {
            this.baseImage.addAction(Tweening.getSquish(0.8f * strength));
            this.iconImage.addAction(Tweening.getSquish(0.2f * strength));
        }
    }

    @Override
    public float getPrefWidth() {
        return this.style.width;
    }

    @Override
    public float getPrefHeight() {
        return this.style.height;
    }

    public void setStyle(AstraXButtonStyle style) {
        this.style = style;
        this.baseImage.setDrawable(this.style.baseDrawable);
        this.baseImage.setSize(this.style.width, this.style.height);
        this.baseImage.setColor(this.style.baseColor.getColor(this));
        this.baseImage.setAlign(1);
        this.baseImage.setOrigin(this.baseImage.getWidth() / 2.0f, this.baseImage.getHeight() / 2.0f);
        this.baseImage.layout();
        if (style.iconDrawable != null) {
            this.setInlineIcon(style.iconDrawable);
        }
        this.setSize(this.style.width, this.style.height);
    }

    public Image getInlineIcon() {
        return this.iconImage;
    }

    public void setInlineIcon(Drawable iconImage) {
        if (iconImage != null) {
            this.style.iconDrawable = iconImage;
            this.iconImage.setVisible(true);
            this.iconImage.setDrawable(this.style.iconDrawable);
            this.iconImage.setSize(this.style.width - this.style.padding * 2, this.style.height - this.style.padding * 2);
            this.iconImage.setColor(this.style.iconColor.getColor(this));
            this.iconImage.setAlign(1);
            this.iconImage.setOrigin(1);
            this.iconImage.setPosition((float)this.style.width / 2.0f - (float)(this.style.width - this.style.padding * 2) / 2.0f, (float)this.style.height / 2.0f - (float)(this.style.height - this.style.padding * 2) / 2.0f);
            this.iconImage.layout();
        } else {
            this.iconImage.setVisible(false);
        }
    }

    public void toggleInlineIconVisibility(boolean visible) {
        this.iconImage.setVisible(visible);
    }

    public void addActionToIcon(Action action) {
        this.iconImage.addAction(action);
    }

    public void clearActionsFromIcon() {
        this.iconImage.clearActions();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.baseImage.setColor(this.style.baseColor.getColor(this));
        if (this.style.iconColor != null) {
            this.iconImage.setColor(this.style.iconColor.getColor(this));
        }
    }

    public AstraXButtonStyle getStyle() {
        return this.style;
    }

    @Override
    public void setUserObject(Object userObject) {
        super.setUserObject(userObject);
        this.baseImage.setUserObject(userObject);
    }

    public static class AstraXButtonStyle {
        public int width = 32;
        public int height = 32;
        public int padding = 10;
        public ButtonSounds buttonSounds = new ButtonSounds();
        public ReactiveColor baseColor;
        public Drawable baseDrawable;
        public ReactiveColor iconColor;
        public Drawable iconDrawable;

        public AstraXButtonStyle copy() {
            AstraXButtonStyle copy = new AstraXButtonStyle();
            copy.width = this.width;
            copy.height = this.height;
            copy.padding = this.padding;
            copy.buttonSounds.soundRelease = this.buttonSounds.soundRelease;
            copy.buttonSounds.soundPressed = this.buttonSounds.soundPressed;
            copy.buttonSounds.soundOver = this.buttonSounds.soundOver;
            copy.baseDrawable = this.baseDrawable;
            if (this.baseColor != null) {
                copy.baseColor = this.baseColor.copy();
            }
            copy.iconDrawable = this.iconDrawable;
            if (this.iconColor != null) {
                copy.iconColor = this.iconColor.copy();
            }
            return copy;
        }
    }
}

