/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.buttons;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.BaseButton;
import com.neutronio.astrax.util.animation.Tweening;

public class AstraXTextButton
extends BaseButton {
    protected ComponentFactory factory;
    protected AstraXTextButtonStyle style;
    private Image baseImage;
    private Image iconImage;
    private boolean squishable = true;
    protected Container<Label> container;
    protected Label label;

    public AstraXTextButton(ComponentFactory componentFactory, String buttonStyle) {
        this(componentFactory, null, buttonStyle);
    }

    @Deprecated
    public AstraXTextButton(ComponentFactory componentFactory, String iconDrawable, String buttonStyle) {
        this(componentFactory, "", iconDrawable, buttonStyle);
    }

    public AstraXTextButton(ComponentFactory componentFactory, String text, String iconDrawable, String buttonStyle) {
        this.factory = componentFactory;
        this.baseImage = new Image();
        this.addActor(this.baseImage);
        this.iconImage = new Image();
        this.iconImage.setTouchable(Touchable.disabled);
        this.addActor(this.iconImage);
        this.label = new Label((CharSequence)"", componentFactory.getSkin());
        this.label.setTouchable(Touchable.disabled);
        this.container = new Container<Label>(this.label);
        this.container.pack();
        this.container.align(1);
        this.addActor(this.container);
        AstraXTextButtonStyle iconStyle = this.factory.getSkin().get(buttonStyle, AstraXTextButtonStyle.class).copy();
        this.setStyle(iconStyle);
        if (iconDrawable != null) {
            this.setInlineIcon(this.factory.getSkin().getDrawable(iconDrawable));
        } else {
            this.setInlineIcon(null);
        }
        this.setText(text);
        this.clickListener = new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (AstraXTextButton.this.isDisabled) {
                    return false;
                }
                if (AstraXTextButton.this.style.buttonSounds.soundPressed != null) {
                    AstraXTextButton.this.factory.playUISound(AstraXTextButton.this.style.buttonSounds.soundPressed);
                }
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (AstraXTextButton.this.isDisabled) {
                    return;
                }
                if (AstraXTextButton.this.style.buttonSounds.soundRelease != null) {
                    AstraXTextButton.this.factory.playUISound(AstraXTextButton.this.style.buttonSounds.soundRelease);
                }
                super.touchUp(event, x, y, pointer, button);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                super.enter(event, x, y, pointer, fromActor);
                if (AstraXTextButton.this.isDisabled) {
                    return;
                }
                if (AstraXTextButton.this.style.buttonSounds.soundOver != null && pointer < 0) {
                    AstraXTextButton.this.factory.playUISound(AstraXTextButton.this.style.buttonSounds.soundOver);
                }
                if (AstraXTextButton.this.isSquishable()) {
                    AstraXTextButton.this.baseImage.addAction(Tweening.getSquish(1.5f, null));
                    AstraXTextButton.this.iconImage.addAction(Tweening.getSquish(0.5f, null));
                    AstraXTextButton.this.label.addAction(Tweening.getSquish(0.5f, null));
                }
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                super.exit(event, x, y, pointer, toActor);
                if (AstraXTextButton.this.isSquishable()) {
                    AstraXTextButton.this.baseImage.addAction(Actions.scaleTo(1.0f, 1.0f, 0.4f, Interpolation.bounce));
                    AstraXTextButton.this.iconImage.addAction(Actions.scaleTo(1.0f, 1.0f, 0.4f, Interpolation.bounce));
                    AstraXTextButton.this.label.addAction(Actions.scaleTo(1.0f, 1.0f, 0.4f, Interpolation.bounce));
                }
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (AstraXTextButton.this.isDisabled) {
                    return;
                }
                if (!AstraXTextButton.this.isChecked) {
                    AstraXTextButton.this.baseImage.addAction(Tweening.getSquish(2.5f, AstraXTextButton.this.getButtonAction()));
                    AstraXTextButton.this.iconImage.addAction(Tweening.getSquish(1.0f, null));
                    AstraXTextButton.this.label.addAction(Tweening.getSquish(1.0f, null));
                } else {
                    AstraXTextButton.this.baseImage.addAction(Tweening.getSquish(0.8f, AstraXTextButton.this.getButtonAction()));
                    AstraXTextButton.this.iconImage.addAction(Tweening.getSquish(0.2f));
                    AstraXTextButton.this.label.addAction(Tweening.getSquish(0.2f));
                }
                if (!AstraXTextButton.this.canCheck) {
                    return;
                }
                AstraXTextButton.this.setChecked(!AstraXTextButton.this.isChecked, true);
            }
        };
        this.addListener(this.clickListener);
    }

    public void setStyle(AstraXTextButtonStyle style) {
        this.style = style;
        this.label.setStyle(this.factory.getSkin().get(style.labelStyle, Label.LabelStyle.class));
        this.label.setAlignment(style.labelAlignment, 1);
        this.container.pad(this.style.labelPadding);
        this.container.minSize(this.style.width, this.style.height);
        this.baseImage.setDrawable(this.style.baseDrawable);
        this.baseImage.setColor(this.style.baseColor.getColor(this));
        this.baseImage.setAlign(1);
        this.baseImage.setOrigin(this.baseImage.getWidth() / 2.0f, this.baseImage.getHeight() / 2.0f);
        if (style.iconDrawable != null) {
            this.setInlineIcon(style.iconDrawable);
        }
        this.setSize(this.style.width, this.style.height);
    }

    public boolean isSquishable() {
        return this.squishable;
    }

    public void setSquishable(boolean squishable) {
        this.squishable = squishable;
    }

    public void setTextAlign(int align) {
        this.label.setAlignment(align);
    }

    public AstraXTextButtonStyle getStyle() {
        return this.style;
    }

    public void setText(String text) {
        this.label.setText(text);
        this.container.pack();
        float width = this.container.getWidth();
        float height = this.container.getHeight();
        this.baseImage.setSize(width, height);
        this.baseImage.setAlign(1);
        this.baseImage.setOrigin(this.baseImage.getWidth() / 2.0f, this.baseImage.getHeight() / 2.0f);
    }

    public String getText() {
        return this.label.getText().toString();
    }

    public Image getInlineIcon() {
        return this.iconImage;
    }

    @Override
    public float getMaxWidth() {
        return this.container.getMaxWidth();
    }

    @Override
    public float getMaxHeight() {
        return this.container.getMaxHeight();
    }

    @Override
    public float getMinWidth() {
        return this.container.getMinWidth();
    }

    @Override
    public float getMinHeight() {
        return this.container.getMinHeight();
    }

    @Override
    public float getPrefWidth() {
        return this.container.getPrefWidth();
    }

    @Override
    public float getPrefHeight() {
        return this.container.getPrefHeight();
    }

    public void setInlineIcon(Drawable iconImage) {
        if (iconImage != null) {
            this.style.iconDrawable = iconImage;
            this.iconImage.setVisible(true);
            this.iconImage.setDrawable(this.style.iconDrawable);
            this.iconImage.setSize(this.style.width - this.style.padding, this.style.height - this.style.padding);
            if (this.style.iconColor != null) {
                this.iconImage.setColor(this.style.iconColor.getColor(this));
            } else {
                this.iconImage.setColor(Color.WHITE);
            }
            this.iconImage.setAlign(1);
            this.iconImage.setOrigin(1);
            this.iconImage.setPosition((float)this.style.width / 2.0f - (float)(this.style.width - this.style.padding) / 2.0f, (float)this.style.height / 2.0f - (float)(this.style.height - this.style.padding) / 2.0f);
        } else {
            this.iconImage.setVisible(false);
        }
    }

    public void addActionToIcon(Action action) {
        this.iconImage.addAction(action);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.baseImage.setColor(this.style.baseColor.getColor(this));
        if (this.style.iconColor != null) {
            this.label.setColor(this.style.iconColor.getColor(this));
        }
        if (this.style.iconDrawable != null && this.style.iconColor != null) {
            this.iconImage.setColor(this.style.iconColor.getColor(this));
        }
    }

    @Override
    public void setUserObject(Object userObject) {
        super.setUserObject(userObject);
        this.baseImage.setUserObject(userObject);
    }

    public static class AstraXTextButtonStyle
    extends AstraXButton.AstraXButtonStyle {
        public String labelStyle;
        public int labelPadding;
        public int labelAlignment = 1;
        public int labelMinWidth = 0;
        public int labelMinHeight = 0;

        @Override
        public AstraXTextButtonStyle copy() {
            AstraXTextButtonStyle copy = new AstraXTextButtonStyle();
            copy.labelStyle = this.labelStyle;
            copy.labelPadding = this.labelPadding;
            copy.width = this.width;
            copy.height = this.height;
            copy.padding = this.padding;
            copy.buttonSounds.soundRelease = this.buttonSounds.soundRelease;
            copy.buttonSounds.soundPressed = this.buttonSounds.soundPressed;
            copy.buttonSounds.soundOver = this.buttonSounds.soundOver;
            copy.baseDrawable = this.baseDrawable;
            if (this.baseColor != null) {
                copy.baseColor = this.baseColor.copy();
            }
            copy.iconDrawable = this.iconDrawable;
            if (this.iconColor != null) {
                copy.iconColor = this.iconColor.copy();
            }
            return copy;
        }
    }
}

