/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.buttons;

import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;

public abstract class BaseButton
extends WidgetGroup
implements Button {
    protected ClickListener clickListener;
    protected ButtonGroup buttonGroup;
    protected boolean isChecked;
    protected boolean isDisabled;
    protected boolean canCheck = true;
    protected boolean programmaticChangeEvents;
    protected CustomAction buttonAction;

    @Override
    public void setButtonGroup(ButtonGroup buttonGroup) {
        this.buttonGroup = buttonGroup;
    }

    @Override
    public boolean canCheck() {
        return this.canCheck;
    }

    @Override
    public void setCanCheck(boolean canCheck) {
        this.canCheck = canCheck;
    }

    @Override
    public void toggle() {
        this.setChecked(!this.isChecked);
    }

    @Override
    public void setChecked(boolean isChecked) {
        this.setChecked(isChecked, this.programmaticChangeEvents);
    }

    public void setChecked(boolean isChecked, boolean fireEvent) {
        if (!this.canCheck) {
            return;
        }
        if (this.isChecked == isChecked) {
            return;
        }
        if (this.buttonGroup != null && !this.buttonGroup.canCheck(this, isChecked)) {
            return;
        }
        this.isChecked = isChecked;
        if (fireEvent) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            if (this.fire(changeEvent)) {
                this.isChecked = !isChecked;
            }
            Pools.free(changeEvent);
        }
    }

    @Override
    public boolean isChecked() {
        return this.isChecked;
    }

    @Override
    public boolean isPressed() {
        if (this.clickListener == null) {
            return false;
        }
        return this.clickListener.isVisualPressed();
    }

    @Override
    public boolean isOver() {
        if (this.clickListener == null) {
            return false;
        }
        return this.clickListener.isOver();
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    @Override
    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
    }

    public CustomAction getButtonAction() {
        return this.buttonAction;
    }

    public void setButtonAction(CustomAction buttonAction) {
        this.buttonAction = buttonAction;
    }
}

