/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.buttons;

import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.BaseButton;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;

public class ButtonList<B extends BaseButton>
extends AstraXComponent {
    private int maxColumns = 3;
    private ButtonGroup<B> entries = new ButtonGroup();

    public ButtonList(ComponentFactory componentFactory) {
        super(componentFactory);
        this.entries.setUncheckLast(true);
        this.entries.setMaxCheckCount(1);
        this.entries.setMinCheckCount(0);
    }

    @Override
    public void clearChildren() {
        this.entries.clear();
        super.clearChildren();
    }

    public ButtonGroup<B> getButtonGroup() {
        return this.entries;
    }

    public B getButton(int index) {
        return (B)((BaseButton)this.entries.getButtons().get(index));
    }

    public int size() {
        return this.entries.getButtons().size;
    }

    public void setMaxColumns(int maxColumns) {
        this.maxColumns = maxColumns;
    }

    public B getSelectedButton() {
        return (B)((BaseButton)this.entries.getChecked());
    }

    public void addEntry(B button, CustomAction customAction) {
        ((BaseButton)button).setProgrammaticChangeEvents(false);
        ((BaseButton)button).setCanCheck(false);
        ((BaseButton)button).setButtonAction(customAction);
        this.entries.add(button);
        this.add(button).minWidth(170.0f).fill().padRight(5.0f).padBottom(5.0f);
        this.row();
    }
}

